/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import twilightforest.components.entity.FortificationShieldAttachment;
import twilightforest.enchantment.RechargeScepterEffect;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFSounds;
import twilightforest.util.TFItemStackUtils;

public class FortificationWandItem
extends Item {
    public FortificationWandItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() == stack.getMaxDamage() && !player.getAbilities().instabuild) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide()) {
            ((FortificationShieldAttachment)player.getData(TFDataAttachments.FORTIFICATION_SHIELDS)).setShields((LivingEntity)player, 5, true);
            if (!player.getAbilities().instabuild) {
                TFItemStackUtils.hurtButDontBreak(stack, 1, (ServerLevel)level, (LivingEntity)player);
            }
        }
        player.playSound((SoundEvent)TFSounds.SHIELD_ADD.get(), 1.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
        if (!player.isCreative()) {
            player.getCooldowns().addCooldown((Item)this, 1200);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity.tickCount % 20 == 0 && level instanceof ServerLevel) {
            int renewal;
            ServerLevel serverLevel = (ServerLevel)level;
            if (stack.has(DataComponents.ENCHANTMENTS) && !isSelected && (renewal = ((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).getLevel(level.holderOrThrow(TFEnchantments.RENEWAL))) > 0) {
                RechargeScepterEffect.applyRecharge(serverLevel, stack, entity);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)Component.translatable((String)"item.twilightforest.scepter.desc", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}).withStyle(ChatFormatting.GRAY));
    }
}

