/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructures;
import twilightforest.world.components.chunkblanketing.CanopyBlanketProcessor;
import twilightforest.world.components.chunkblanketing.ChunkBlanketProcessor;
import twilightforest.world.components.chunkblanketing.ChunkBlanketType;
import twilightforest.world.components.chunkblanketing.GlacierBlanketProcessor;

public final class ChunkBlanketProcessors {
    public static final DeferredRegister<ChunkBlanketType> CHUNK_BLANKETING_TYPES = DeferredRegister.create(TFRegistries.Keys.CHUNK_BLANKET_TYPE, (String)"twilightforest");
    public static final Codec<ChunkBlanketType> TYPE_CODEC = Codec.lazyInitialized(() -> TFRegistries.CHUNK_BLANKET_TYPES.byNameCodec());
    public static final Codec<ChunkBlanketProcessor> DISPATCH_CODEC = TYPE_CODEC.dispatch("type", ChunkBlanketProcessor::getType, ChunkBlanketType::getCodec);
    public static final DeferredHolder<ChunkBlanketType, ChunkBlanketType> CANOPY = ChunkBlanketProcessors.registerType("canopy", CanopyBlanketProcessor.CODEC);
    public static final DeferredHolder<ChunkBlanketType, ChunkBlanketType> GLACIER = ChunkBlanketProcessors.registerType("glacier", GlacierBlanketProcessor.CODEC);
    public static final ResourceKey<ChunkBlanketProcessor> DARK_FOREST_CANOPY = ResourceKey.create(TFRegistries.Keys.CHUNK_BLANKET_PROCESSORS, (ResourceLocation)TwilightForestMod.prefix("dark_forest_canopy"));
    public static final ResourceKey<ChunkBlanketProcessor> SNOWY_FOREST_GLACIER = ResourceKey.create(TFRegistries.Keys.CHUNK_BLANKET_PROCESSORS, (ResourceLocation)TwilightForestMod.prefix("snowy_forest_glacier"));

    public static DeferredHolder<ChunkBlanketType, ChunkBlanketType> registerType(String name, MapCodec<? extends ChunkBlanketProcessor> codec) {
        return CHUNK_BLANKETING_TYPES.register(name, () -> () -> codec);
    }

    public static void bootstrap(BootstrapContext<ChunkBlanketProcessor> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(DARK_FOREST_CANOPY, (Object)new CanopyBlanketProcessor((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(TFBiomes.DARK_FOREST), biomes.getOrThrow(TFBiomes.DARK_FOREST_CENTER)}), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)TFBlocks.HARDENED_DARK_LEAVES.value())), 14, (HolderSet<Structure>)HolderSet.direct((Holder[])new Holder[]{structures.getOrThrow(TFStructures.DARK_TOWER)})));
        context.register(SNOWY_FOREST_GLACIER, (Object)new GlacierBlanketProcessor((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(TFBiomes.GLACIER)}), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.PACKED_ICE), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.ICE), 32));
    }

    public static void chunkBlanketing(ChunkAccess chunkAccess, WorldGenRegion worldGenRegion) {
        ChunkPos chunkPos = chunkAccess.getPos();
        ObjectArraySet biomesInChunk = new ObjectArraySet();
        for (LevelChunkSection levelchunksection : worldGenRegion.getChunk(chunkPos.x, chunkPos.z).getSections()) {
            levelchunksection.getBiomes().getAll(((Set)biomesInChunk)::add);
        }
        Iterator modifierIterator = worldGenRegion.registryAccess().registry(TFRegistries.Keys.CHUNK_BLANKET_PROCESSORS).map(Registry::stream).orElseGet(Stream::empty).filter(arg_0 -> ChunkBlanketProcessors.lambda$chunkBlanketing$2((Set)biomesInChunk, arg_0)).iterator();
        Function<BlockPos, Holder<Biome>> biomeGetter = arg_0 -> ((WorldGenRegion)worldGenRegion).getBiome(arg_0);
        while (modifierIterator.hasNext()) {
            ((ChunkBlanketProcessor)modifierIterator.next()).processChunk(worldGenRegion.getRandom().fork(), biomeGetter, chunkAccess);
        }
    }

    private static /* synthetic */ boolean lambda$chunkBlanketing$2(Set biomesInChunk, ChunkBlanketProcessor modifier) {
        return modifier.biomesForApplication().stream().anyMatch(biomesInChunk::contains);
    }
}

