/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFSounds;

public class Squirrel
extends Animal {
    public Squirrel(EntityType<? extends Squirrel> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.38f));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(ItemTagGenerator.SQUIRREL_TEMPT_ITEMS), true));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 2.0f, (double)0.8f, (double)1.4f));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, (double)0.8f, (double)1.4f));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 8.0f, (double)0.8f, (double)1.4f));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 8.0f, (double)0.8f, (double)1.4f));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Fox.class, 8.0f, (double)0.8f, (double)1.4f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public float getWalkTargetValue(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos.below());
        if (state.is(BlockTags.LEAVES)) {
            return 12.0f;
        }
        if (state.is(BlockTags.LOGS)) {
            return 15.0f;
        }
        if (state.is(BlockTags.DIRT)) {
            return 10.0f;
        }
        return (float)this.level().getMaxLocalRawBrightness(pos) - 0.5f;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.SQUIRREL_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.SQUIRREL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.SQUIRREL_DEATH.get();
    }
}

