/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.goal.GhastguardAttackGoal;
import twilightforest.entity.ai.goal.GhastguardHomedFlightGoal;
import twilightforest.entity.ai.goal.GhastguardRandomFlyGoal;
import twilightforest.init.TFSounds;

public class CarminiteGhastguard
extends Ghast
implements EnforcedHomePoint {
    private static final EntityDataAccessor<Byte> ATTACK_STATUS = SynchedEntityData.defineId(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ATTACK_TIMER = SynchedEntityData.defineId(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ATTACK_PREVTIMER = SynchedEntityData.defineId(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.defineId(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_GLOBAL_POS);
    private GhastguardAttackGoal attackGoal;
    protected float wanderFactor = 16.0f;

    public CarminiteGhastguard(EntityType<? extends CarminiteGhastguard> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_STATUS, (Object)0);
        builder.define(ATTACK_TIMER, (Object)0);
        builder.define(ATTACK_PREVTIMER, (Object)0);
        builder.define(HOME_POINT, Optional.empty());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new GhastguardHomedFlightGoal(this));
        this.goalSelector.addGoal(5, (Goal)new GhastguardRandomFlyGoal(this));
        this.goalSelector.addGoal(7, (Goal)new Ghast.GhastLookGoal((Ghast)this));
        this.attackGoal = new GhastguardAttackGoal(this);
        this.goalSelector.addGoal(7, (Goal)this.attackGoal);
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public float getWanderFactor() {
        return this.wanderFactor;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Ghast.createAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTGUARD_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.CARMINITE_GHASTGUARD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTGUARD_DEATH.get();
    }

    public SoundEvent getFireSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTGUARD_SHOOT.get();
    }

    public SoundEvent getWarnSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTGUARD_WARN.get();
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public int getAmbientSoundInterval() {
        return 160;
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public void aiStep() {
        if (this.getRandom().nextBoolean()) {
            this.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.getRandom().nextDouble() * (double)this.getBbHeight() - 0.25, this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
        }
        super.aiStep();
    }

    protected void customServerAiStep() {
        boolean status = this.getTarget() != null && this.shouldAttack(this.getTarget());
        this.getEntityData().set(ATTACK_STATUS, (Object)((byte)(status ? 1 : 0)));
        this.getEntityData().set(ATTACK_TIMER, (Object)((byte)this.attackGoal.attackTimer));
        this.getEntityData().set(ATTACK_PREVTIMER, (Object)((byte)this.attackGoal.prevAttackTimer));
    }

    public int getAttackStatus() {
        return ((Byte)this.getEntityData().get(ATTACK_STATUS)).byteValue();
    }

    public int getAttackTimer() {
        return ((Byte)this.getEntityData().get(ATTACK_TIMER)).byteValue();
    }

    public int getPrevAttackTimer() {
        return ((Byte)this.getEntityData().get(ATTACK_PREVTIMER)).byteValue();
    }

    public boolean shouldAttack(LivingEntity living) {
        return true;
    }

    public int getMaxHeadXRot() {
        return 500;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    public static boolean ghastSpawnHandler(EntityType<? extends CarminiteGhastguard> entityType, LevelAccessor accessor, MobSpawnType type, BlockPos pos, RandomSource random) {
        return accessor.getDifficulty() != Difficulty.PEACEFUL && CarminiteGhastguard.checkMobSpawnRules(entityType, (LevelAccessor)accessor, (MobSpawnType)type, (BlockPos)pos, (RandomSource)random);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this) && !world.containsAnyLiquid(this.getBoundingBox());
    }

    @Override
    public boolean isMobWithinHomeArea(Entity entity) {
        if (!this.isRestrictionPointValid(entity.level().dimension())) {
            return true;
        }
        return entity.blockPosition().getY() > this.level().getMinBuildHeight() + 64 && entity.blockPosition().getY() < this.level().getMaxBuildHeight() - 64 && this.getRestrictionPoint().pos().distSqr((Vec3i)entity.blockPosition()) < (double)(this.getHomeRadius() * this.getHomeRadius());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.loadHomePointFromNbt(compound);
    }

    @Override
    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.getEntityData().get(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.getEntityData().set(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 64;
    }
}

