/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.monster.CarminiteGhastguard;

public class GhastguardAttackGoal
extends Goal {
    private final CarminiteGhastguard ghast;
    public int attackTimer;
    public int prevAttackTimer;

    public GhastguardAttackGoal(CarminiteGhastguard ghast) {
        this.ghast = ghast;
    }

    public boolean canUse() {
        return this.ghast.getTarget() != null && this.ghast.shouldAttack(this.ghast.getTarget());
    }

    public void start() {
        this.prevAttackTimer = 0;
        this.attackTimer = 0;
    }

    public void stop() {
        this.ghast.setCharging(false);
    }

    public void tick() {
        LivingEntity target = this.ghast.getTarget();
        if (target.distanceToSqr((Entity)this.ghast) < 4096.0 && this.ghast.getSensing().hasLineOfSight((Entity)target)) {
            this.prevAttackTimer = this.attackTimer++;
            this.ghast.getLookControl().setLookAt((Entity)target, 10.0f, (float)this.ghast.getMaxHeadXRot());
            if (this.attackTimer == 10) {
                this.ghast.playSound(this.ghast.getWarnSound(), 10.0f, this.ghast.getVoicePitch());
            }
            if (this.attackTimer == 20) {
                if (this.ghast.shouldAttack(target)) {
                    this.ghast.playSound(this.ghast.getFireSound(), 10.0f, this.ghast.getVoicePitch());
                    this.spitFireball();
                    this.prevAttackTimer = this.attackTimer;
                }
                this.attackTimer = -40;
            }
        } else if (this.attackTimer > 0) {
            this.prevAttackTimer = this.attackTimer--;
        }
        this.ghast.setCharging(this.attackTimer > 10);
    }

    public void spitFireball() {
        Vec3 vec3d = this.ghast.getViewVector(1.0f);
        double d2 = this.ghast.getTarget().getX() - (this.ghast.getX() + vec3d.x() * 4.0);
        double d3 = this.ghast.getTarget().getBoundingBox().minY + (double)(this.ghast.getTarget().getBbHeight() / 2.0f) - (0.5 + this.ghast.getY() + (double)(this.ghast.getBbHeight() / 2.0f));
        double d4 = this.ghast.getTarget().getZ() - (this.ghast.getZ() + vec3d.z() * 4.0);
        LargeFireball fireball = new LargeFireball(this.ghast.level(), (LivingEntity)this.ghast, new Vec3(d2, d3, d4).normalize(), this.ghast.getExplosionPower());
        fireball.setPos(this.ghast.getX() + vec3d.x() * 4.0, this.ghast.getY() + (double)(this.ghast.getBbHeight() / 2.0f) + 0.5, this.ghast.getZ() + vec3d.z() * 4.0);
        this.ghast.level().addFreshEntity((Entity)fireball);
        if (this.ghast.getRandom().nextInt(6) == 0) {
            this.ghast.setTarget(null);
        }
    }
}

