/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.IBreathAttacker;

public class BreathAttackGoal<T extends Mob>
extends Goal {
    private final T entityHost;
    private LivingEntity attackTarget;
    private Vec3 breathPos;
    private final int maxDuration;
    private final float attackChance;
    private final float breathRange;
    private int durationLeft;

    public BreathAttackGoal(T living, float range, int time, float chance) {
        this.entityHost = living;
        this.breathRange = range;
        this.maxDuration = time;
        this.attackChance = chance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        this.attackTarget = this.entityHost.getLastHurtByMob();
        if (this.attackTarget == null || this.entityHost.distanceTo((Entity)this.attackTarget) > this.breathRange || !this.entityHost.getSensing().hasLineOfSight((Entity)this.attackTarget) || !EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE).test(this.attackTarget)) {
            return false;
        }
        this.breathPos = this.attackTarget.getEyePosition();
        return this.entityHost.getRandom().nextFloat() < this.attackChance;
    }

    public void start() {
        this.durationLeft = this.maxDuration;
        ((IBreathAttacker)this.entityHost).setBreathing(true);
    }

    public boolean canContinueToUse() {
        return this.durationLeft > 0 && this.entityHost.isAlive() && this.attackTarget.isAlive() && this.entityHost.distanceTo((Entity)this.attackTarget) <= this.breathRange && this.entityHost.getSensing().hasLineOfSight((Entity)this.attackTarget) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE).test(this.attackTarget);
    }

    public void tick() {
        Entity target;
        --this.durationLeft;
        this.entityHost.getLookControl().setLookAt(this.breathPos);
        this.faceVec(this.breathPos, 100.0f, 100.0f);
        if (this.maxDuration - this.durationLeft > 5 && (target = this.getHeadLookTarget()) != null) {
            ((IBreathAttacker)this.entityHost).doBreathAttack(target);
            this.entityHost.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        }
    }

    public void stop() {
        this.durationLeft = 0;
        this.attackTarget = null;
        ((IBreathAttacker)this.entityHost).setBreathing(false);
    }

    @Nullable
    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        double offset = 3.0;
        Vec3 srcVec = new Vec3(this.entityHost.getX(), this.entityHost.getY() + 0.25, this.entityHost.getZ());
        Vec3 lookVec = this.entityHost.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 0.5f;
        List possibleList = this.entityHost.level().getEntities(this.entityHost, this.entityHost.getBoundingBox().move(lookVec.x() * offset, lookVec.y() * offset, lookVec.z() * offset).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        if (this.entityHost.isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList(Objects.requireNonNull(this.entityHost.getParts())));
        }
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable() || possibleEntity == this.entityHost || !EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE).test(possibleEntity)) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void faceVec(Vec3 pos, float yawConstraint, float pitchConstraint) {
        double xOffset = pos.x() - this.entityHost.getX();
        double zOffset = pos.z() - this.entityHost.getZ();
        double yOffset = this.entityHost.getY() + 0.25 - pos.y();
        double distance = Mth.sqrt((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.entityHost.setXRot(-this.updateRotation(this.entityHost.getXRot(), zdAngle, pitchConstraint));
        this.entityHost.setYRot(this.updateRotation(this.entityHost.getYRot(), xyAngle, yawConstraint));
    }

    private float updateRotation(float current, float target, float maxDelta) {
        float delta = Mth.wrapDegrees((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return current + delta;
    }
}

