/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import twilightforest.beanification.Autowired;
import twilightforest.beanification.Component;
import twilightforest.util.DisplayUtil;
import twilightforest.world.components.structures.util.ProgressionPiece;

@Component
public class DisplayPiecesCommand {
    @Autowired
    private DisplayUtil displayUtil;

    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"display_pieces").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"filter_structure", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.STRUCTURE)).executes(this::debugDisplayPieces));
    }

    private int debugDisplayPieces(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Holder.Reference structure = ResourceKeyArgument.getStructure(context, (String)"filter_structure");
        if (!structure.isBound()) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        BlockPos commandPos = BlockPos.containing((Position)source.getPosition());
        StructureStart structureAt = level.structureManager().getStructureAt(commandPos, (Structure)structure.value());
        BoundingBox structureBox = structureAt.getBoundingBox();
        int successes = this.displayUtil.spawnBlockDisplay((Level)level, structureBox, Blocks.RED_STAINED_GLASS.defaultBlockState(), 0.01f) ? 1 : 0;
        List structurePieces = structureAt.getPieces();
        int maxPieces = structurePieces.size();
        for (StructurePiece piece : structurePieces) {
            ProgressionPiece shieldablePiece;
            BlockState displayState = piece instanceof ProgressionPiece && (shieldablePiece = (ProgressionPiece)piece).isComponentProtected() ? Blocks.LIME_STAINED_GLASS.defaultBlockState() : Blocks.LIGHT_BLUE_STAINED_GLASS.defaultBlockState();
            ResourceLocation key = BuiltInRegistries.STRUCTURE_PIECE.getKey((Object)piece.getType());
            float padding = Mth.lerp((float)((float)successes / (float)maxPieces), (float)0.003f, (float)0.025f);
            BoundingBox boundingBox = piece.getBoundingBox();
            if (!this.displayUtil.spawnBlockDisplay((Level)level, boundingBox, displayState, padding)) continue;
            MutableComponent nameLabel = net.minecraft.network.chat.Component.literal((String)(key == null ? "missing key" : key.toString()));
            this.displayUtil.setTextEntity((Level)level, (double)(boundingBox.minX() + boundingBox.maxX() + 1) * 0.5, (float)boundingBox.minY() - padding, (float)boundingBox.maxZ() + padding + 1.0f, Display.BillboardConstraints.FIXED, (net.minecraft.network.chat.Component)nameLabel);
            ++successes;
        }
        return successes;
    }
}

