/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;
import twilightforest.TwilightForestMod;
import twilightforest.components.item.PotionFlaskComponent;
import twilightforest.item.BrittleFlaskItem;

public class PotionFlaskTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation BORDER_SPRITE = TwilightForestMod.prefix("flask_bar_border");
    private static final ResourceLocation DOSE_SPRITE = TwilightForestMod.prefix("flask_dose_bar");
    private static final Component EMPTY_DESCRIPTION = Component.translatable((String)"item.twilightforest.flask.empty_description");
    public static final int WIDTH = 115;
    private final PotionFlaskComponent component;
    private final int maxDoses;

    public PotionFlaskTooltipComponent(BrittleFlaskItem.Tooltip tooltip) {
        this.component = tooltip.component();
        this.maxDoses = tooltip.maxDoses();
    }

    public int getHeight() {
        return this.getDescriptionHeight(Minecraft.getInstance().font) + 13 + 8;
    }

    public int getWidth(Font font) {
        return 115;
    }

    private int getDescriptionHeight(Font font) {
        if (this.component.potion().potion().isPresent()) {
            int height = 0;
            for (Component component : this.getPotionTooltips()) {
                if (component.getString().isEmpty()) {
                    Objects.requireNonNull(font);
                    height += 9;
                }
                int n = font.split((FormattedText)component, 115).size();
                Objects.requireNonNull(font);
                height += n * 9 + 1;
            }
            return height;
        }
        int n = font.split((FormattedText)EMPTY_DESCRIPTION, 115).size();
        Objects.requireNonNull(font);
        return n * 9 + 1;
    }

    private List<Component> getPotionTooltips() {
        if (this.component.potion().potion().isPresent()) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add((Component)Component.translatable((String)Potion.getName((Optional)this.component.potion().potion(), (String)"item.minecraft.potion.effect.")));
            this.component.potion().addPotionTooltip(tooltips::add, 1.0f, Minecraft.getInstance().level.tickRateManager().tickrate());
            return tooltips;
        }
        return List.of();
    }

    private int getContentXOffset(int offs) {
        return (offs - 115) / 2;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int offs = 113;
        if (this.component.potion().potion().isEmpty()) {
            graphics.drawWordWrap(font, (FormattedText)EMPTY_DESCRIPTION, x, y, 115, 0xAAAAAA);
        } else {
            int height = 0;
            for (Component component : this.getPotionTooltips()) {
                int color;
                int n = color = component.getStyle().getColor() != null ? component.getStyle().getColor().getValue() : 0xAAAAAA;
                if (component.getString().isEmpty()) {
                    Objects.requireNonNull(font);
                    height += 9;
                } else {
                    graphics.drawWordWrap(font, (FormattedText)component, x, y + height, 115, color);
                }
                int n2 = font.split((FormattedText)component, 115).size();
                Objects.requireNonNull(font);
                height += n2 * 9 + 1;
            }
        }
        this.drawPotionBar(x + this.getContentXOffset(offs), y + this.getDescriptionHeight(font) + 4, font, graphics);
    }

    private void drawPotionBar(int x, int y, Font font, GuiGraphics graphics) {
        int segmentSplit = this.getWidth(font) / this.maxDoses;
        if (this.component.doses() <= 0) {
            graphics.drawCenteredString(font, (Component)Component.translatable((String)"item.twilightforest.flask.empty"), x + 57 + 1, y + 3, 0xFFFFFF);
        }
        this.renderPotion(graphics.pose(), x + 1, y + 13, this.component.doses() * segmentSplit - 1, 13, this.component.potion().getColor());
        if (this.component.breakage() > 0) {
            int xPos = x + segmentSplit * (3 - this.component.breakage());
            RenderSystem.enableBlend();
            graphics.fill(xPos, y, xPos + segmentSplit * this.component.breakage(), y + 13, -1438432445);
            RenderSystem.disableBlend();
        }
        int widthProg = segmentSplit;
        for (int i = 1; i < this.maxDoses; ++i) {
            graphics.blitSprite(DOSE_SPRITE, x + widthProg, y, 1, 13);
            widthProg += segmentSplit;
        }
        graphics.blitSprite(BORDER_SPRITE, x, y, 115, 13);
    }

    private void renderPotion(PoseStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getStillTexture());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix4f = stack.last().pose();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width == 0) break;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            int shiftedX = x + 16 - maskRight;
            float uLocalDif = uDif * (float)maskRight / 16.0f;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height == 0) continue block0;
                int y = yPosition - (yTile + 1) * 16;
                int maskTop = 16 - height;
                float vLocalDif = vDif * (float)maskTop / 16.0f;
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + 16), 0.0f).setUv(uMin + uLocalDif, vMax).setColor(color);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + 16), 0.0f).setUv(uMax, vMax).setColor(color);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + maskTop), 0.0f).setUv(uMax, vMin + vLocalDif).setColor(color);
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + maskTop), 0.0f).setUv(uMin + uLocalDif, vMin + vLocalDif).setColor(color);
            }
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

