/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import twilightforest.entity.monster.MosquitoSwarm;

public class MosquitoSwarmModel
extends HierarchicalModel<MosquitoSwarm> {
    private final ModelPart root;
    private final ModelPart core;
    private final ModelPart group1;
    private final ModelPart group2;
    private final ModelPart group3;
    private final ModelPart group4;
    private final ModelPart group5;
    private final ModelPart group6;
    private static final RandomSource rand = RandomSource.create();

    public MosquitoSwarmModel(ModelPart root) {
        this.root = root;
        this.core = this.root.getChild("core");
        this.group1 = this.core.getChild("group_1");
        this.group2 = this.core.getChild("group_2");
        this.group3 = this.core.getChild("group_3");
        this.group4 = this.core.getChild("group_4");
        this.group5 = this.core.getChild("group_5");
        this.group6 = this.core.getChild("group_6");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition core = partdefinition.addOrReplaceChild("core", CubeListBuilder.create().texOffs(rand.nextInt(28), rand.nextInt(28)).addBox(-0.5f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartPose offset = PartPose.offset((float)-0.5f, (float)-2.0f, (float)-0.5f);
        for (Direction dir : Direction.values()) {
            MosquitoSwarmModel.addBugsToGroup(dir.ordinal(), core.addOrReplaceChild("group_" + (dir.ordinal() + 1), CubeListBuilder.create().texOffs(rand.nextInt(28), rand.nextInt(28)).addBox((float)dir.getStepX() * 11.0f, (float)dir.getStepY() * 11.0f, (float)dir.getStepZ() * 11.0f, 1.0f, 1.0f, 1.0f), offset));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void addBugsToGroup(int iteration, PartDefinition parent) {
        int bugs = 16;
        for (int i = 0; i < 16; ++i) {
            Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
            float yRot = (float)i * 22.5f * (float)Math.PI / 180.0f;
            vec.rotateX(yRot);
            float bugX = (rand.nextFloat() - rand.nextFloat()) * 16.0f;
            float bugY = (rand.nextFloat() - rand.nextFloat()) * 16.0f;
            float bugZ = (rand.nextFloat() - rand.nextFloat()) * 16.0f;
            parent.addOrReplaceChild("bug_" + (iteration * 16 + i), CubeListBuilder.create().texOffs(rand.nextInt(28), rand.nextInt(28)).addBox(bugX, bugY, bugZ, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)vec.x(), (float)vec.y(), (float)vec.z(), (float)0.0f, (float)yRot, (float)0.0f));
        }
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(MosquitoSwarm entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(MosquitoSwarm entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.core.yRot = ((float)entity.tickCount + partialTicks) / 5.0f;
        this.core.xRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.core.zRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.group1.yRot = ((float)entity.tickCount + partialTicks) / 2.0f;
        this.group1.xRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 6.0f)) / 2.0f;
        this.group1.zRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.group2.yRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 2.0f)) / 3.0f;
        this.group2.xRot = ((float)entity.tickCount + partialTicks) / 5.0f;
        this.group2.zRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.group3.yRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 7.0f)) / 3.0f;
        this.group3.xRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 4.0f)) / 2.0f;
        this.group3.zRot = ((float)entity.tickCount + partialTicks) / 5.0f;
        this.group4.xRot = ((float)entity.tickCount + partialTicks) / 2.0f;
        this.group4.zRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 6.0f)) / 2.0f;
        this.group4.yRot = Mth.sin((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.group5.zRot = ((float)entity.tickCount + partialTicks) / 2.0f;
        this.group5.yRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.group5.xRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 5.0f)) / 4.0f;
        this.group6.zRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 7.0f)) / 3.0f;
        this.group6.xRot = Mth.cos((float)(((float)entity.tickCount + partialTicks) / 4.0f)) / 2.0f;
        this.group6.yRot = ((float)entity.tickCount + partialTicks) / 5.0f;
    }
}

