/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;

public class CicadaBlockEntity
extends BlockEntity {
    public final float randRot = (float)RandomSource.create().nextInt(4) * 90.0f;
    public int currentYaw;
    private int yawDelay;
    private int desiredYaw;
    private int singDuration;
    private boolean singing;
    private int singDelay;

    public CicadaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.CICADA.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CicadaBlockEntity te) {
        if (level.isClientSide()) {
            if (te.yawDelay > 0) {
                --te.yawDelay;
            } else {
                if (te.currentYaw == 0 && te.desiredYaw == 0) {
                    te.yawDelay = 200 + level.getRandom().nextInt(200);
                    te.desiredYaw = level.getRandom().nextInt(15) - level.getRandom().nextInt(15);
                }
                if (te.currentYaw < te.desiredYaw) {
                    ++te.currentYaw;
                }
                if (te.currentYaw > te.desiredYaw) {
                    --te.currentYaw;
                }
                if (te.currentYaw == te.desiredYaw) {
                    te.desiredYaw = 0;
                }
            }
            if (te.singDelay > 0) {
                --te.singDelay;
            } else {
                if (te.singing && te.singDuration == 0) {
                    te.playSong();
                }
                if (te.singing && te.singDuration >= 100) {
                    te.singing = false;
                    te.singDuration = 0;
                }
                if (te.singing) {
                    ++te.singDuration;
                    te.doSingAnimation();
                }
                if (!te.singing && te.singDuration <= 0) {
                    te.singing = true;
                    te.singDelay = 100 + level.getRandom().nextInt(100);
                }
            }
        }
    }

    private void doSingAnimation() {
        if (this.getLevel().getRandom().nextInt(5) == 0) {
            double rx = (float)this.getBlockPos().getX() + this.getLevel().getRandom().nextFloat();
            double ry = (float)this.getBlockPos().getY() + this.getLevel().getRandom().nextFloat();
            double rz = (float)this.getBlockPos().getZ() + this.getLevel().getRandom().nextFloat();
            this.getLevel().addParticle((ParticleOptions)ParticleTypes.NOTE, rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    private void playSong() {
        if (!TFConfig.silentCicadas) {
            this.getLevel().playLocalSound((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)TFSounds.CICADA.get(), SoundSource.NEUTRAL, 1.0f, (this.getLevel().getRandom().nextFloat() - this.getLevel().getRandom().nextFloat()) * 0.2f + 1.0f, false);
        }
    }
}

