/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.LightableBlock;
import twilightforest.components.item.SkullCandles;
import twilightforest.init.TFDataComponents;

public class WallSkullCandleBlock
extends AbstractSkullCandleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<WallSkullCandleBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SkullBlock.Type.CODEC.fieldOf("kind").forGetter(AbstractSkullCandleBlock::getType), (App)WallSkullCandleBlock.propertiesCodec()).apply((Applicative)instance, WallSkullCandleBlock::new));
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (Object)Direction.WEST, (Object)Block.box((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)));
    private static final Map<Direction, VoxelShape> PIGLIN_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)3.0, (double)4.0, (double)8.0, (double)13.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)3.0, (double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)3.0, (double)8.0, (double)12.0, (double)13.0), (Object)Direction.WEST, (Object)Block.box((double)8.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0)));
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectOpenHashMap var0 = new Int2ObjectOpenHashMap();
        var0.defaultReturnValue((Object)ImmutableList.of());
        var0.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.25, 0.5)));
        var0.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 1.19, 0.5), (Object)new Vec3(0.625, 1.25, 0.44)));
        var0.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.063, 0.625), (Object)new Vec3(0.375, 1.19, 0.5), (Object)new Vec3(0.56, 1.25, 0.44)));
        var0.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 1.063, 0.56), (Object)new Vec3(0.625, 1.19, 0.56), (Object)new Vec3(0.375, 1.19, 0.375), (Object)new Vec3(0.56, 1.25, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)var0);
    });

    public WallSkullCandleBlock(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(type, properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getType() == SkullBlock.Types.PIGLIN ? PIGLIN_AABBS.get(state.getValue((Property)FACING)) : AABBS.get(state.getValue((Property)FACING));
    }

    @Override
    public Iterable<Vec3> getParticleOffsets(BlockState state, LevelAccessor accessor, BlockPos pos) {
        return (Iterable)PARTICLE_OFFSETS.get((Object)state.getValue((Property)CANDLES));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState state = this.defaultBlockState();
        Level getter = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        for (Direction dir : directions = ctx.getNearestLookingDirections()) {
            if (!dir.getAxis().isHorizontal()) continue;
            Direction var10 = dir.getOpposite();
            state = (BlockState)state.setValue((Property)FACING, (Comparable)var10);
            if (getter.getBlockState(pos.relative(dir)).canBeReplaced(ctx)) continue;
            return (BlockState)((BlockState)state.setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(((SkullCandles)ctx.getItemInHand().getOrDefault(TFDataComponents.SKULL_CANDLES, (Object)SkullCandles.DEFAULT)).count()));
        }
        return null;
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (state.getValue((Property)LIGHTING) != LightableBlock.Lighting.NONE) {
            this.getParticleOffsets(state, (LevelAccessor)level, pos).forEach(offset -> {
                Vec3 trueOffset = offset.add((double)((float)pos.getX() - (float)dir.getStepX() * 0.25f), (double)pos.getY(), (double)((float)pos.getZ() - (float)dir.getStepZ() * 0.25f));
                this.addParticlesAndSound(level, trueOffset.x(), trueOffset.y(), trueOffset.z(), rand, (LightableBlock.Lighting)((Object)((Object)state.getValue((Property)LIGHTING))));
            });
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}));
    }
}

