/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.LightableBlock;
import twilightforest.components.item.SkullCandles;
import twilightforest.init.TFDataComponents;

public class SkullCandleBlock
extends AbstractSkullCandleBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final MapCodec<SkullCandleBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SkullBlock.Type.CODEC.fieldOf("kind").forGetter(AbstractSkullCandleBlock::getType), (App)SkullCandleBlock.propertiesCodec()).apply((Applicative)instance, SkullCandleBlock::new));
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape PIGLIN_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    protected static final VoxelShape ONE_CANDLE = Block.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape TWO_CANDLE = Block.box((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)9.0);
    protected static final VoxelShape THREE_CANDLE = Block.box((double)5.0, (double)8.0, (double)6.0, (double)10.0, (double)14.0, (double)11.0);
    protected static final VoxelShape FOUR_CANDLE = Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)10.0);
    protected static final VoxelShape SKULL_WITH_ONE = Shapes.or((VoxelShape)SHAPE, (VoxelShape)ONE_CANDLE);
    protected static final VoxelShape SKULL_WITH_TWO = Shapes.or((VoxelShape)SHAPE, (VoxelShape)TWO_CANDLE);
    protected static final VoxelShape SKULL_WITH_THREE = Shapes.or((VoxelShape)SHAPE, (VoxelShape)THREE_CANDLE);
    protected static final VoxelShape SKULL_WITH_FOUR = Shapes.or((VoxelShape)SHAPE, (VoxelShape)FOUR_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_ONE = Shapes.or((VoxelShape)PIGLIN_SHAPE, (VoxelShape)ONE_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_TWO = Shapes.or((VoxelShape)PIGLIN_SHAPE, (VoxelShape)TWO_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_THREE = Shapes.or((VoxelShape)PIGLIN_SHAPE, (VoxelShape)THREE_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_FOUR = Shapes.or((VoxelShape)PIGLIN_SHAPE, (VoxelShape)FOUR_CANDLE);
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectOpenHashMap var0 = new Int2ObjectOpenHashMap();
        var0.defaultReturnValue((Object)ImmutableList.of());
        var0.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.96, 0.5)));
        var0.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 0.88, 0.5), (Object)new Vec3(0.625, 0.96, 0.44)));
        var0.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.73, 0.625), (Object)new Vec3(0.375, 0.88, 0.5), (Object)new Vec3(0.56, 0.96, 0.44)));
        var0.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 0.73, 0.56), (Object)new Vec3(0.625, 0.88, 0.56), (Object)new Vec3(0.375, 0.88, 0.375), (Object)new Vec3(0.56, 0.96, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)var0);
    });

    public SkullCandleBlock(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(type, properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        boolean piglin = this.getType() == SkullBlock.Types.PIGLIN;
        return switch ((Integer)state.getValue((Property)CANDLES)) {
            default -> {
                if (piglin) {
                    yield PIGLIN_SKULL_WITH_ONE;
                }
                yield SKULL_WITH_ONE;
            }
            case 2 -> {
                if (piglin) {
                    yield PIGLIN_SKULL_WITH_TWO;
                }
                yield SKULL_WITH_TWO;
            }
            case 3 -> {
                if (piglin) {
                    yield PIGLIN_SKULL_WITH_THREE;
                }
                yield SKULL_WITH_THREE;
            }
            case 4 -> piglin ? PIGLIN_SKULL_WITH_FOUR : SKULL_WITH_FOUR;
        };
    }

    @Override
    public Iterable<Vec3> getParticleOffsets(BlockState state, LevelAccessor accessor, BlockPos pos) {
        return (Iterable)PARTICLE_OFFSETS.get((Object)state.getValue((Property)CANDLES));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(Mth.floor((double)((double)(ctx.getRotation() * 16.0f / 360.0f) + 0.5)) & 0xF))).setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(((SkullCandles)ctx.getItemInHand().getOrDefault(TFDataComponents.SKULL_CANDLES, (Object)SkullCandles.DEFAULT)).count()));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rot.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{ROTATION}));
    }
}

