/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.spawner.SinisterSpawnerBlockEntity;
import twilightforest.block.entity.spawner.SinisterSpawnerLogic;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;

public class SinisterSpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<SinisterSpawnerBlock> CODEC = SinisterSpawnerBlock.simpleCodec(SinisterSpawnerBlock::new);

    public SinisterSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SinisterSpawnerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SinisterSpawnerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)TFBlockEntities.SINISTER_SPAWNER.value()), (BlockEntityTicker)(level.isClientSide ? SinisterSpawnerBlockEntity::clientTick : SinisterSpawnerBlockEntity::serverTick));
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        return 15 + level.getRandom().nextInt(15) + level.getRandom().nextInt(15);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        Spawner.appendHoverText((ItemStack)stack, tooltip, (String)"SpawnData");
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        return Shapes.empty();
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SinisterSpawnerBlockEntity entity;
        SinisterSpawnerLogic sinisterSpawnerLogic;
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof SinisterSpawnerBlockEntity && (sinisterSpawnerLogic = (entity = (SinisterSpawnerBlockEntity)blockEntity).getSpawner()) instanceof SinisterSpawnerLogic) {
            SinisterSpawnerLogic logic = sinisterSpawnerLogic;
            List<ParticleOptions> particleOptions = this.particlesFromItem(stack);
            if (!particleOptions.isEmpty()) {
                logic.setParticles(particleOptions, true);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private List<ParticleOptions> particlesFromItem(ItemStack stack) {
        if (stack.is(TFItems.NAGA_TROPHY) || stack.is(TFBlocks.NAGA_BOSS_SPAWNER.asItem())) {
            return List.of(ParticleTypes.SMOKE, ParticleTypes.CRIT);
        }
        if (stack.is(TFItems.LICH_TROPHY) || stack.is(TFBlocks.LICH_BOSS_SPAWNER.asItem())) {
            return List.of(ParticleTypes.SMOKE, (ParticleOptions)TFParticleType.OMINOUS_FLAME.get());
        }
        if (stack.is(TFItems.MINOSHROOM_TROPHY) || stack.is(TFBlocks.MINOSHROOM_BOSS_SPAWNER.asItem())) {
            return List.of(ParticleTypes.SMOKE, ParticleTypes.CRIMSON_SPORE);
        }
        if (stack.is(TFItems.HYDRA_TROPHY) || stack.is(TFBlocks.HYDRA_BOSS_SPAWNER.asItem())) {
            return List.of(ParticleTypes.SMOKE, ParticleTypes.FLAME);
        }
        if (stack.is(TFItems.KNIGHT_PHANTOM_TROPHY) || stack.is(TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER.asItem())) {
            return List.of(ParticleTypes.SMOKE, (ParticleOptions)TFParticleType.OMINOUS_FLAME.get());
        }
        if (stack.is(TFItems.UR_GHAST_TROPHY) || stack.is(TFBlocks.UR_GHAST_BOSS_SPAWNER.asItem())) {
            return List.of(ParticleTypes.SMOKE, DustParticleOptions.REDSTONE);
        }
        if (stack.is(TFItems.ALPHA_YETI_TROPHY) || stack.is(TFBlocks.ALPHA_YETI_BOSS_SPAWNER.asItem())) {
            return List.of((ParticleOptions)TFParticleType.SNOW.get(), ParticleTypes.FALLING_WATER);
        }
        if (stack.is(TFItems.SNOW_QUEEN_TROPHY) || stack.is(TFBlocks.SNOW_QUEEN_BOSS_SPAWNER.asItem())) {
            return List.of((ParticleOptions)TFParticleType.SNOW.get(), (ParticleOptions)TFParticleType.SNOW_WARNING.get());
        }
        if (stack.is(TFBlocks.FINAL_BOSS_BOSS_SPAWNER.asItem())) {
            return List.of((ParticleOptions)TFParticleType.ANNIHILATE.get());
        }
        if (stack.is(TFItems.QUEST_RAM_TROPHY)) {
            return List.of((ParticleOptions)TFParticleType.TRANSFORMATION_PARTICLE.get());
        }
        return List.of();
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder paramBuilder) {
        SinisterSpawnerBlockEntity entity;
        LootTable lootTable;
        List drops = super.getDrops(state, paramBuilder);
        Object object = paramBuilder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof SinisterSpawnerBlockEntity && (lootTable = (entity = (SinisterSpawnerBlockEntity)((Object)object)).getLootTable()) != null) {
            LootParams params = paramBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
            return ConcatenatedListView.of((List[])new List[]{drops, lootTable.getRandomItems(params)});
        }
        return drops;
    }
}

