/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BinaryRotatedBlock
extends Block {
    public static final MapCodec<BinaryRotatedBlock> CODEC = BinaryRotatedBlock.simpleCodec(BinaryRotatedBlock::new);
    public static final BooleanProperty ROTATED = BooleanProperty.create((String)"rotated");

    public BinaryRotatedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<BinaryRotatedBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ROTATED, (Comparable)Boolean.valueOf(context.getHorizontalDirection().getAxis() == Direction.Axis.Z));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        boolean rotated = (Boolean)state.getValue((Property)ROTATED);
        return (BlockState)state.setValue((Property)ROTATED, (Comparable)Boolean.valueOf(!rotated));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean rotated = (Boolean)state.getValue((Property)ROTATED);
        return (BlockState)state.setValue((Property)ROTATED, (Comparable)Boolean.valueOf(!rotated));
    }
}

