/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.beanification.processors.inject;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforgespi.language.ModFileScanData;
import twilightforest.beanification.BeanContext;
import twilightforest.beanification.BeanDefinition;
import twilightforest.beanification.BeanLifeCycle;
import twilightforest.beanification.Directory;
import twilightforest.beanification.InternalAutowired;
import twilightforest.beanification.internal.DistAnnotationRetriever;
import twilightforest.beanification.internal.InternalReflectionHelper;
import twilightforest.beanification.processors.BeanProcessor;
import twilightforest.beanification.processors.IBeanProcessor;

@BeanProcessor(value=BeanLifeCycle.Inject)
public class DirectoryAnnotationInjectBeanProcessor
implements IBeanProcessor {
    @InternalAutowired
    private DistAnnotationRetriever distAnnotationRetriever;
    @InternalAutowired
    private InternalReflectionHelper internalReflectionHelper;

    @Override
    public void process(BeanContext.BeanLifeCycleContext context, ModContainer modContainer, ModFileScanData scanData) throws Throwable {
        this.processBeans(context, scanData);
        this.processStatic(context, scanData);
    }

    private void processBeans(BeanContext.BeanLifeCycleContext context, ModFileScanData scanData) throws IllegalAccessException {
        for (Map.Entry<BeanDefinition<?>, Object> entry : context.beans().orElseThrow().entrySet()) {
            Object bean = entry.getValue();
            if (bean instanceof Record) continue;
            Iterator it = this.distAnnotationRetriever.retrieve(scanData, ElementType.FIELD, Directory.class).filter(a -> this.internalReflectionHelper.classOrSuperEquals(a.clazz(), bean.getClass())).iterator();
            while (it.hasNext()) {
                ModFileScanData.AnnotationData data = (ModFileScanData.AnnotationData)it.next();
                for (Field field : this.internalReflectionHelper.getAllDirectoryFieldsIncludingSuper(bean.getClass(), data.memberName())) {
                    context.currentInjection().orElseThrow().set(field);
                    if (this.internalReflectionHelper.isStatic(field)) {
                        throw new IllegalStateException("@Directory fields must be non-static inside Beans");
                    }
                    field.trySetAccessible();
                    Directory annotation = field.getAnnotation(Directory.class);
                    field.set(bean, this.injectList(context, scanData, bean.getClass(), annotation.value(), annotation.recursive()));
                }
            }
        }
    }

    private void processStatic(BeanContext.BeanLifeCycleContext context, ModFileScanData scanData) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Iterator it = this.distAnnotationRetriever.retrieve(scanData, ElementType.FIELD, Directory.class).iterator();
        while (it.hasNext()) {
            ModFileScanData.AnnotationData data = (ModFileScanData.AnnotationData)it.next();
            context.currentInjection().orElseThrow().set(data.clazz());
            Class<?> type = Class.forName(data.clazz().getClassName());
            Field field = this.internalReflectionHelper.getDeclaredField(type, data.memberName());
            context.currentInjection().orElseThrow().set(field);
            Directory annotation = field.getAnnotation(Directory.class);
            if (!this.internalReflectionHelper.isStatic(field)) continue;
            field.trySetAccessible();
            field.set(null, this.injectList(context, scanData, type, annotation.value(), annotation.recursive()));
        }
    }

    private List<?> injectList(BeanContext.BeanLifeCycleContext context, ModFileScanData scanData, Class<?> parent, Class<?> classFilter, boolean recursive) {
        return scanData.getClasses().stream().filter(data -> {
            String pkg = data.clazz().getInternalName().replaceAll("/", ".");
            pkg = pkg.substring(0, pkg.lastIndexOf("."));
            return recursive ? pkg.contains(parent.getPackageName()) : pkg.equals(parent.getPackageName());
        }).map(data -> {
            try {
                return Class.forName(data.clazz().getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).filter(classFilter::isAssignableFrom).map(data -> new BeanDefinition(data, null)).map(data -> context.injector().orElseThrow().apply((BeanDefinition<?>)data)).filter(Objects::nonNull).toList();
    }
}

