/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.beanification.internal;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.ApiStatus;
import twilightforest.beanification.Autowired;
import twilightforest.beanification.InternalAutowired;
import twilightforest.beanification.internal.InternalReflectionHelper;

@ApiStatus.Internal
public class BeanConstructorLocater {
    @InternalAutowired
    private InternalReflectionHelper internalReflectionHelper;

    public Constructor<?> locate(Class<?> c) {
        Constructor<?> targetConstructor = null;
        boolean hasAutowiredCtor = false;
        for (Constructor<?> constructor : this.internalReflectionHelper.getConstructors(c)) {
            if (targetConstructor == null && constructor.getParameterCount() == 0) {
                targetConstructor = constructor;
                continue;
            }
            if (!this.internalReflectionHelper.allParametersHaveAnnotation(constructor.getParameterAnnotations(), Autowired.class)) continue;
            if (hasAutowiredCtor) {
                throw new IllegalArgumentException("Conflicting Constructors found: " + constructor.toGenericString() + " and " + targetConstructor.toGenericString());
            }
            hasAutowiredCtor = true;
            targetConstructor = constructor;
        }
        if (targetConstructor == null) {
            throw new IllegalStateException("Could not find any Constructors in class " + String.valueOf(c));
        }
        return targetConstructor;
    }
}

