/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.mixin;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Inject(method={"shouldEntityAppearGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldBeGlowing(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        boolean targetSeen;
        if (!(entity instanceof Player)) {
            return;
        }
        float distance = entity.distanceTo((Entity)ClientUtil.getPlayer());
        if (distance < 10.0f || (double)distance > ReviveMeConfig.reviveGlowMaxDistance) {
            return;
        }
        FallenData cap = FallenData.get((LivingEntity)entity);
        if (!cap.isFallen()) {
            return;
        }
        BlockHitResult rayResult = ClientUtil.getMinecraft().player.level().clip(new ClipContext(ClientUtil.getMinecraft().player.getEyePosition(1.0f), entity.getEyePosition(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        boolean bl = targetSeen = rayResult.getType() == HitResult.Type.MISS;
        if (!targetSeen && !cap.isCallingForHelp()) {
            return;
        }
        cir.setReturnValue((Object)true);
    }
}

