/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.network.payload;

import invoker54.invocore.client.util.ClientUtil;
import invoker54.reviveme.ReviveMe;
import invoker54.reviveme.client.VanillaKeybindHandler;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.init.NetworkInit;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public record SyncClientCapMsg(String uuid, CompoundTag capDataTag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncClientCapMsg> TYPE = new CustomPacketPayload.Type(ReviveMe.makeResource(NetworkInit.createID(SyncClientCapMsg.class)));
    public static final StreamCodec<FriendlyByteBuf, SyncClientCapMsg> CODEC = StreamCodec.of(SyncClientCapMsg::encode, SyncClientCapMsg::new);

    public SyncClientCapMsg(UUID uuid, CompoundTag capDataTag) {
        this(uuid.toString(), capDataTag);
    }

    public SyncClientCapMsg(FriendlyByteBuf buf) {
        this(buf.readUtf(), buf.readNbt());
    }

    public static void encode(FriendlyByteBuf buf, SyncClientCapMsg msg) {
        buf.writeUtf(msg.uuid);
        buf.writeNbt((Tag)msg.capDataTag);
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToClient(TYPE, CODEC, (msg, context) -> context.enqueueWork(() -> {
            Level level = context.player().level();
            Player player = level.getPlayerByUUID(UUID.fromString(msg.uuid));
            if (player == null) {
                return;
            }
            FallenData.get((LivingEntity)player).readNBT((Tag)msg.capDataTag);
            if (player == ClientUtil.getPlayer() && FallenData.get((LivingEntity)player).isFallen()) {
                VanillaKeybindHandler.useHeld = false;
                VanillaKeybindHandler.attackHeld = false;
            } else if (!FallenData.get((LivingEntity)player).isFallen()) {
                player.setPose(Pose.STANDING);
            }
        }));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

