/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.network.payload;

import invoker54.reviveme.ReviveMe;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import invoker54.reviveme.init.NetworkInit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public record RestartDeathTimerMsg() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RestartDeathTimerMsg> TYPE = new CustomPacketPayload.Type(ReviveMe.makeResource(NetworkInit.createID(RestartDeathTimerMsg.class)));
    public static final StreamCodec<FriendlyByteBuf, RestartDeathTimerMsg> CODEC = StreamCodec.of((A, B) -> {}, friendlyByteBuf -> new RestartDeathTimerMsg());

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, CODEC, (msg, context) -> context.enqueueWork(() -> {
            Player reviverPlayer = context.player();
            FallenData reviverCap = FallenData.get((LivingEntity)reviverPlayer);
            if (reviverCap.getOtherPlayer() == null) {
                return;
            }
            Player fallenPlayer = reviverPlayer.level().getPlayerByUUID(reviverCap.getOtherPlayer());
            if (fallenPlayer == null) {
                return;
            }
            FallenData fallenCap = FallenData.get((LivingEntity)fallenPlayer);
            reviverCap.setOtherPlayer(null);
            fallenCap.setOtherPlayer(null);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)reviverPlayer, (CustomPacketPayload)new SyncClientCapMsg(reviverPlayer.getUUID(), reviverCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)fallenPlayer, (CustomPacketPayload)new SyncClientCapMsg(fallenPlayer.getUUID(), fallenCap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

