/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.network.payload;

import invoker54.invocore.common.ModLogger;
import invoker54.invocore.common.util.MathUtil;
import invoker54.reviveme.ReviveMe;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import invoker54.reviveme.init.NetworkInit;
import invoker54.reviveme.init.SoundInit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record CallForHelpMsg() implements CustomPacketPayload
{
    private static final ModLogger LOGGER = ModLogger.getLogger(CallForHelpMsg.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    public static final CustomPacketPayload.Type<CallForHelpMsg> TYPE = new CustomPacketPayload.Type(ReviveMe.makeResource(NetworkInit.createID(CallForHelpMsg.class)));
    public static final StreamCodec<FriendlyByteBuf, CallForHelpMsg> CODEC = StreamCodec.of((A, B) -> {}, friendlyByteBuf -> new CallForHelpMsg());

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, CODEC, (msg, context) -> context.enqueueWork(() -> {
            Player player = context.player();
            if (player.isDeadOrDying()) {
                return;
            }
            FallenData cap = FallenData.get((LivingEntity)player);
            cap.callForHelp();
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncClientCapMsg(player.getUUID(), cap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            float pitch = MathUtil.randomFloat((float)0.7f, (float)1.4f);
            float volume = MathUtil.randomFloat((float)1.0f, (float)1.5f);
            player.playSound(SoundInit.CALL_FOR_HELP, volume, pitch);
        }));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

