/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import invoker54.invocore.client.util.InvoText;
import invoker54.invocore.common.ModLogger;
import invoker54.invocore.common.util.MathUtil;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallEvent;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import invoker54.reviveme.init.MobEffectInit;
import invoker54.reviveme.init.NetworkInit;
import invoker54.reviveme.init.SoundInit;
import invoker54.reviveme.mixin.FoodMixin;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="revive_me")
public class FallenTimerEvent {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenTimerEvent.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @SubscribeEvent
    public static void changeGamemode(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player player = event.getEntity();
        if (!FallenData.get((LivingEntity)player).isFallen()) {
            return;
        }
        if (event.getNewGameMode() != GameType.CREATIVE && event.getNewGameMode() != GameType.SPECTATOR) {
            return;
        }
        FallenTimerEvent.revivePlayer(player, false);
    }

    @SubscribeEvent
    public static void TickDownTimer(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        if (event.getEntity().isDeadOrDying()) {
            return;
        }
        FallenData cap = FallenData.get((LivingEntity)event.getEntity());
        if (!cap.isFallen() || cap.getOtherPlayer() != null) {
            return;
        }
        if (event.getEntity().isSprinting()) {
            event.getEntity().setSprinting(false);
        }
        if (event.getEntity().getHealth() != 1.0f) {
            event.getEntity().setHealth(1.0f);
        }
        event.getEntity().getFoodData().setFoodLevel(0);
        cap.removeOriginalEffects(event.getEntity());
        FallEvent.modifyPotionEffects(event.getEntity());
        if (!cap.shouldDie()) {
            return;
        }
        cap.kill(event.getEntity());
    }

    @SubscribeEvent
    public static void TickProgress(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        FallenData cap = FallenData.get((LivingEntity)event.getEntity());
        if (cap.getOtherPlayer() == null) {
            return;
        }
        if (cap.getProgress(true) < 1.0f) {
            return;
        }
        if (!cap.isFallen()) {
            return;
        }
        Player fellPlayer = event.getEntity();
        ServerPlayer reviver = fellPlayer.getServer().getPlayerList().getPlayer(cap.getOtherPlayer());
        FallenTimerEvent.takeFromReviver((Player)reviver, fellPlayer);
        FallenTimerEvent.revivePlayer(fellPlayer, false);
    }

    public static void takeFromReviver(Player reviver, Player fallen) {
        if (reviver == null) {
            return;
        }
        FallenData cap = FallenData.get((LivingEntity)fallen);
        if (!reviver.isCreative()) {
            int amount = (int)cap.getPenaltyAmount(reviver);
            int leftoverAmount = 0;
            block1 : switch (ReviveMeConfig.penaltyType) {
                case NONE: {
                    break;
                }
                case HEALTH: {
                    leftoverAmount = Math.max(0, Math.round((float)amount - reviver.getAbsorptionAmount()));
                    reviver.setAbsorptionAmount(reviver.getAbsorptionAmount() - (float)amount);
                    reviver.setHealth(Math.max(1.0f, reviver.getHealth() - (float)leftoverAmount));
                    break;
                }
                case EXPERIENCE: {
                    reviver.giveExperienceLevels(-amount);
                    break;
                }
                case FOOD: {
                    FoodData food = reviver.getFoodData();
                    leftoverAmount = Math.max(0, Math.round((float)amount - food.getSaturationLevel()));
                    ((FoodMixin)food).setSaturationLevel(Math.max(0.0f, food.getSaturationLevel() - (float)amount));
                    food.setFoodLevel(Math.max(0, food.getFoodLevel() - leftoverAmount));
                    ((ServerPlayer)reviver).connection.send((Packet)new ClientboundSetHealthPacket(reviver.getHealth(), reviver.getFoodData().getFoodLevel(), reviver.getFoodData().getSaturationLevel()));
                    break;
                }
                case ITEM: {
                    ItemStack penaltyStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)ReviveMeConfig.penaltyItem)));
                    try {
                        if (!ReviveMeConfig.penaltyItemData.isEmpty()) {
                            penaltyStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)ReviveMeConfig.penaltyItemData));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage());
                    }
                    Inventory playerInv = reviver.getInventory();
                    for (int a = 0; a < playerInv.getContainerSize(); ++a) {
                        ItemStack currStack = playerInv.getItem(a);
                        if (!ItemStack.isSameItem((ItemStack)penaltyStack, (ItemStack)currStack) || !FallenData.hasMatchingTags(penaltyStack, currStack)) continue;
                        int takeAway = Math.min(amount, currStack.getCount());
                        currStack.setCount(currStack.getCount() - takeAway);
                        if ((amount -= takeAway) == 0) break block1;
                    }
                    break;
                }
            }
        }
        cap = FallenData.get((LivingEntity)reviver);
        cap.setOtherPlayer(null);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)reviver, (CustomPacketPayload)new SyncClientCapMsg(reviver.getUUID(), cap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void revivePlayer(Player fallen, boolean isCommand) {
        FallenData cap = FallenData.get((LivingEntity)fallen);
        float healAmount = ReviveMeConfig.revivedHealth <= 0.0 ? fallen.getMaxHealth() : (ReviveMeConfig.revivedHealth > 0.0 && ReviveMeConfig.revivedHealth < 1.0 ? (float)((double)fallen.getMaxHealth() * ReviveMeConfig.revivedHealth) : ReviveMeConfig.revivedHealth.floatValue());
        fallen.setHealth(healAmount);
        float foodAmount = ReviveMeConfig.revivedFood < 0.0 ? 40.0f : (ReviveMeConfig.revivedFood >= 0.0 && ReviveMeConfig.revivedFood < 1.0 ? (float)(40.0 * ReviveMeConfig.revivedFood) : ReviveMeConfig.revivedFood.floatValue());
        fallen.getFoodData().setFoodLevel((int)Math.min(foodAmount, 20.0f));
        ((FoodMixin)fallen.getFoodData()).setSaturationLevel(Math.max(0.0f, foodAmount - 20.0f));
        fallen.removeAllEffects();
        cap.loadEffects(fallen);
        fallen.addEffect(new MobEffectInstance(MobEffectInit.FALLEN_EFFECT, (int)(ReviveMeConfig.fallenPenaltyTimer * 20.0), cap.getPenaltyMultiplier()));
        if (ReviveMeConfig.reviveInvulnTime != 0.0) {
            fallen.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
            fallen.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, (int)(ReviveMeConfig.reviveInvulnTime * 20.0), 5));
        }
        cap.setFallen(false);
        fallen.setPose(Pose.STANDING);
        fallen.level().playSound(null, fallen.getX(), fallen.getY(), fallen.getZ(), SoundInit.REVIVED, SoundSource.PLAYERS, 1.0f, MathUtil.randomFloat((float)0.7f, (float)1.0f));
        InvoText reviveTxt = InvoText.translate((String)"revive_me.commands.revive_pass", (Object[])new Object[]{fallen.getDisplayName()});
        NetworkInit.sendMessage(reviveTxt.getText(), isCommand, (Entity)fallen);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)fallen, (CustomPacketPayload)new SyncClientCapMsg(fallen.getUUID(), cap.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

