/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.event;

import com.mojang.brigadier.context.ParsedCommandNode;
import invoker54.invocore.common.ModLogger;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.CommandEvent;

@EventBusSubscriber(modid="revive_me")
public class CommandEvents {
    private static final ModLogger LOGGER = ModLogger.getLogger(CommandEvents.class, (AtomicBoolean)ReviveMeConfig.debugMode);

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        List nodes = event.getParseResults().getContext().getNodes();
        if (nodes.isEmpty()) {
            return;
        }
        String rootName = ((ParsedCommandNode)nodes.get(0)).getNode().getName();
        Entity entity = ((CommandSourceStack)event.getParseResults().getContext().getSource()).getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player == null) {
            return;
        }
        if (!FallenData.get((LivingEntity)player).isFallen()) {
            return;
        }
        boolean whitelist = ReviveMeConfig.blockedCommands.contains("//");
        boolean blockEverything = ReviveMeConfig.blockedCommands.contains("/");
        boolean isCommandInList = ReviveMeConfig.blockedCommands.stream().anyMatch(s -> !s.isEmpty() && rootName.contains((CharSequence)s));
        if (blockEverything || isCommandInList && !whitelist || !isCommandInList && whitelist) {
            if (!ReviveMeConfig.silenceCommandMessages) {
                player.sendSystemMessage((Component)Component.translatable((String)"revive_me.chat.blocked_command"));
            }
            event.setCanceled(true);
        }
    }
}

