/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.common.capability;

import com.mojang.serialization.DynamicOps;
import invoker54.invocore.common.ModLogger;
import invoker54.invocore.common.util.CommonUtil;
import invoker54.invocore.common.util.MathUtil;
import invoker54.reviveme.common.config.ReviveMeConfig;
import invoker54.reviveme.common.event.FallenTimerEvent;
import invoker54.reviveme.common.network.payload.SyncClientCapMsg;
import invoker54.reviveme.init.AttachmentTypesInit;
import invoker54.reviveme.init.MobEffectInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class FallenData
implements INBTSerializable<CompoundTag> {
    private static final ModLogger LOGGER = ModLogger.getLogger(FallenData.class, (AtomicBoolean)ReviveMeConfig.debugMode);
    public static final String FALLEN_BOOL = "isFallenREVIVE";
    public static final String FELL_START_LONG = "fellStartREVIVE";
    public static final String FELL_END_DOUBLE = "fellEndREVIVE";
    public static final String REVIVE_START_LONG = "revStartREVIVE";
    public static final String REVIVE_END_INT = "revEndREVIVE";
    public static final String OTHERPLAYER_UUID = "otherPlayerREVIVE";
    public static final String PENALTY_MULTIPLIER_INT = "penaltyMultiplierIntREVIVE";
    public static final String CALLED_FOR_HELP_LONG = "calledForHelpLong";
    public static final String SAVED_EFFECTS_TAG = "savedEffectsTag";
    public static final String DOWNED_BY_PLAYER_BOOL = "DOWNED_BY_PLAYER_BOOL";
    public static final String IS_EFFECTS_REMOVED = "IS_EFFECTS_REMOVED";
    public static final String SELF_REVIVE_OPTIONS_STRING = "SELF_REVIVE_OPTIONS_STRING";
    public static final String SACRIFICEITEMS_COMPOUND = "SACRIFICEITEMS_COMPOUND";
    public static final String STATUS_EFFECTS_COMPOUND = "STATUS_EFFECTS_COMPOUND";
    public static final String SELF_REVIVE_COUNT_INT = "SELF_REVIVE_COUNT_INT";
    protected HolderLookup.Provider provider;
    protected Level level;
    protected long revStart = 0L;
    protected int revEnd = 0;
    protected long fellStart = 0L;
    protected double fellEnd = 0.0;
    protected DamageSource damageSource;
    protected boolean isFallen = false;
    protected long fallenTick = 0L;
    protected UUID otherPlayer = null;
    protected long calledForHelpTime = 0L;
    protected int penaltyMultiplier = 0;
    protected CompoundTag savedEffectsTag = new CompoundTag();
    protected List<SELFREVIVETYPE> selfReviveTypeList = new ArrayList<SELFREVIVETYPE>(ReviveMeConfig.selfReviveOptions);
    protected List<ItemStack> sacrificialItems = new ArrayList<ItemStack>();
    protected List<MobEffect> negativeStatusEffects = new ArrayList<MobEffect>();
    protected int selfReviveCount = 0;
    protected boolean isDownedByPlayer = false;
    protected boolean isEffectsRemoved = false;

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.provider = provider;
        return this.writeNBT();
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundTag) {
        this.provider = provider;
        this.readNBT((Tag)compoundTag);
    }

    public static FallenData get(LivingEntity player) {
        FallenData cap = (FallenData)player.getData(AttachmentTypesInit.FALLEN_DATA);
        if (cap.level == null) {
            cap.level = player.getCommandSenderWorld();
        }
        if (cap.provider == null) {
            cap.provider = cap.level.registryAccess();
        }
        if (cap.damageSource == null) {
            cap.damageSource = cap.level.damageSources().fellOutOfWorld();
        }
        return cap;
    }

    public void removeOriginalEffects(Player player) {
        if (this.isEffectsRemoved) {
            return;
        }
        try {
            player.removeAllEffects();
            this.isEffectsRemoved = true;
        }
        catch (Exception e) {
            LOGGER.warn("Effect removal failed, remove effects later...");
            e.printStackTrace();
        }
    }

    public boolean canSelfRevive() {
        if (ReviveMeConfig.maxSelfRevives != -1 && this.getSelfReviveCount() >= ReviveMeConfig.maxSelfRevives) {
            return false;
        }
        return !ReviveMeConfig.disableSelfReviveIfPlayerDowned || !this.isDownedByPlayer;
    }

    public void callForHelp() {
        this.calledForHelpTime = this.level.getGameTime();
    }

    public boolean isCallingForHelp() {
        return this.callForHelpCooldown() != 1.0;
    }

    public long callForHelpTicks() {
        return this.level.getGameTime() - this.calledForHelpTime;
    }

    public double callForHelpCooldown() {
        long timePassed = this.callForHelpTicks();
        return Math.min((double)timePassed / (ReviveMeConfig.reviveHelpDuration * 20.0), 1.0);
    }

    public float getPenaltyAmount(Player player) {
        Double actualAmount = ReviveMeConfig.penaltyAmount;
        if (actualAmount > 0.0 && actualAmount < 1.0) {
            actualAmount = actualAmount * this.countReviverPenaltyAmount(player);
        }
        if (player.isCreative()) {
            actualAmount = 0.0;
        }
        return Math.round(actualAmount);
    }

    public void kill(Player player) {
        player.playSound(SoundEvents.PLAYER_DEATH, 1.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
        player.getCombatTracker().recordDamage(this.getDamageSource(), 1.0f);
        if (this.damageSource.getEntity() instanceof Player) {
            player.setLastHurtByPlayer((Player)this.damageSource.getEntity());
        }
        if (this.damageSource.getEntity() instanceof Mob) {
            player.setLastHurtByMob((LivingEntity)((Mob)this.damageSource.getEntity()));
        }
        player.die(this.damageSource);
        player.setHealth(0.0f);
    }

    public double countReviverPenaltyAmount(Player reviver) {
        switch (ReviveMeConfig.penaltyType.ordinal()) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return reviver.getHealth() + reviver.getAbsorptionAmount();
            }
            case 2: {
                return reviver.experienceLevel;
            }
            case 3: {
                return (float)reviver.getFoodData().getFoodLevel() + Math.max(reviver.getFoodData().getSaturationLevel(), 0.0f);
            }
            case 4: {
                ItemStack penaltyStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)ReviveMeConfig.penaltyItem)));
                if (!ReviveMeConfig.penaltyItemData.isEmpty()) {
                    penaltyStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)ReviveMeConfig.penaltyItemData));
                }
                int count = 0;
                for (int a = 0; a < reviver.getInventory().getContainerSize(); ++a) {
                    ItemStack containerStack = reviver.getInventory().getItem(a);
                    if (!ItemStack.isSameItem((ItemStack)containerStack, (ItemStack)penaltyStack) || !FallenData.hasMatchingTags(containerStack, penaltyStack)) continue;
                    count += containerStack.getCount();
                }
                return count;
            }
        }
        return 0.0;
    }

    public static boolean hasMatchingTags(ItemStack defaultStack, ItemStack otherStack) {
        boolean hasOtherTag;
        boolean hasDefaultTag = defaultStack.has(DataComponents.CUSTOM_DATA);
        if (hasDefaultTag != (hasOtherTag = otherStack.has(DataComponents.CUSTOM_DATA))) {
            return false;
        }
        return !hasDefaultTag || ((CustomData)defaultStack.get(DataComponents.CUSTOM_DATA)).matchedBy(((CustomData)otherStack.get(DataComponents.CUSTOM_DATA)).copyTag());
    }

    public boolean hasEnough(Player reviver) {
        if (reviver.isCreative()) {
            return true;
        }
        if (ReviveMeConfig.penaltyType == PENALTYPE.NONE) {
            return true;
        }
        return this.countReviverPenaltyAmount(reviver) - (double)this.getPenaltyAmount(reviver) >= 0.0;
    }

    public void setDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
        this.isDownedByPlayer = this.damageSource.getEntity() instanceof Player;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public float GetTimeLeft(boolean divideByMax) {
        double maxSeconds = this.getPenaltyTicks(this.fellEnd);
        if (ReviveMeConfig.timeLeft == 0) {
            maxSeconds = 0.0;
        }
        if (divideByMax) {
            return (float)(1.0 - (double)(this.level.getGameTime() - this.fellStart) / maxSeconds);
        }
        return (float)(((double)this.fellStart + maxSeconds - (double)this.level.getGameTime()) / 20.0);
    }

    public float getKillTime(boolean divideByMax) {
        if (ReviveMeConfig.pvpTimer == -1) {
            return -1.0f;
        }
        double maxSeconds = this.getPenaltyTicks(ReviveMeConfig.pvpTimer * 20);
        if (divideByMax) {
            return (float)Math.max(0.0, 1.0 - (double)(this.level.getGameTime() - this.fellStart) / maxSeconds);
        }
        return (float)Math.max(0.0, ((double)this.fellStart + maxSeconds - (double)this.level.getGameTime()) / 20.0);
    }

    public boolean shouldDie() {
        return ReviveMeConfig.timeLeft != 0 && this.GetTimeLeft(false) <= 0.0f;
    }

    public boolean canDie() {
        return this.fallenTick != this.level.getGameTime();
    }

    public void SetTimeLeft(long timeStart, double maxSeconds) {
        this.fellStart = timeStart;
        this.fellEnd = (long)(maxSeconds * 20.0);
    }

    public void resumeFallTimer() {
        this.fellStart = this.level.getGameTime() - (this.revStart - this.fellStart);
    }

    public boolean isFallen() {
        return this.isFallen;
    }

    public void setFallen(boolean fallen) {
        this.isFallen = fallen;
        if (!fallen) {
            this.setProgress(0L, 1);
            this.SetTimeLeft(0L, 1.0);
            this.setOtherPlayer(null);
            this.calledForHelpTime = 0L;
            this.isEffectsRemoved = false;
        } else if (this.level != null) {
            this.fallenTick = this.level.getGameTime();
        }
    }

    public boolean isDownedByPlayer() {
        return this.isDownedByPlayer;
    }

    public UUID getOtherPlayer() {
        return this.otherPlayer;
    }

    public boolean isReviver(UUID targUUID) {
        if (targUUID == null) {
            return false;
        }
        if (this.getOtherPlayer() == null) {
            return false;
        }
        return this.getOtherPlayer().equals(targUUID);
    }

    public void setOtherPlayer(UUID playerID) {
        this.otherPlayer = playerID;
    }

    public void setProgress(long timeStart, int seconds) {
        this.revStart = timeStart;
        this.revEnd = seconds * 20;
    }

    public float getProgress(boolean divideByMax) {
        long passedTicks = Math.min((long)this.revEnd, this.level.getGameTime() - this.revStart);
        return divideByMax ? (float)passedTicks / (float)this.revEnd : (float)passedTicks;
    }

    public SELFREVIVETYPE getSelfReviveOption(int mouseButton) {
        return this.selfReviveTypeList.get(mouseButton);
    }

    public void useReviveOption(SELFREVIVETYPE selectedOption, Player player) {
        Inventory playerInv = player.getInventory();
        double penaltyPercentage = this.getSelfPenaltyPercentage();
        ++this.selfReviveCount;
        this.selfReviveTypeList.remove((Object)selectedOption);
        this.selfReviveTypeList.add(selectedOption);
        switch (selectedOption.ordinal()) {
            case 0: {
                if ((double)player.level().random.nextFloat() < ReviveMeConfig.reviveChance * (1.0 - penaltyPercentage)) {
                    FallenTimerEvent.revivePlayer(player, false);
                    return;
                }
                if (ReviveMeConfig.reviveChanceKillOnFail) break;
                player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, MathUtil.randomFloat((float)0.7f, (float)1.0f), MathUtil.randomFloat((float)0.8f, (float)1.0f));
                if (!this.canSelfRevive() && !player.getServer().isDedicatedServer() && player.getServer().getPlayerCount() == 1) break;
                this.refreshSelfReviveTypes(player);
                CompoundTag nbt = new CompoundTag();
                nbt.put(player.getStringUUID(), (Tag)this.writeNBT());
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncClientCapMsg(player.getUUID(), this.writeNBT()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            case 1: {
                if (this.getItemList().isEmpty()) break;
                FallenTimerEvent.revivePlayer(player, false);
                block10: for (ItemStack sacrificeStack : this.getItemList()) {
                    int count = FallenData.countItem(playerInv, sacrificeStack);
                    int amountToLose = (int)Math.round(Math.max(1.0, (double)count * (ReviveMeConfig.sacrificialItemPercent * (1.0 + penaltyPercentage))));
                    for (int a = 0; a < playerInv.getContainerSize(); ++a) {
                        ItemStack containerStack;
                        if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !ItemStack.isSameItem((ItemStack)sacrificeStack, (ItemStack)(containerStack = playerInv.getItem(a))) || !FallenData.hasMatchingTags(sacrificeStack, containerStack)) continue;
                        int takeAway = Math.min(amountToLose, containerStack.getCount());
                        containerStack.setCount(containerStack.getCount() - takeAway);
                        if ((amountToLose -= takeAway) == 0) continue block10;
                    }
                }
                this.sacrificialItems.clear();
                return;
            }
            case 2: {
                Pair<Integer, List<ItemStack>> specificPair = this.getSpecificItem(player);
                if ((Integer)specificPair.getKey() < ReviveMeConfig.specificItemCount) break;
                FallenTimerEvent.revivePlayer(player, false);
                int amountLeft = (Integer)specificPair.getKey();
                ItemStack defaultStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)ReviveMeConfig.specificItem)));
                try {
                    if (!ReviveMeConfig.specificItemData.isEmpty()) {
                        defaultStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)ReviveMeConfig.specificItemData));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
                for (int a = 0; a < playerInv.getContainerSize(); ++a) {
                    ItemStack containerStack = playerInv.getItem(a);
                    if (!ItemStack.isSameItem((ItemStack)defaultStack, (ItemStack)containerStack) || !FallenData.hasMatchingTags(defaultStack, containerStack)) continue;
                    int takeAway = Math.min(amountLeft, containerStack.getCount());
                    containerStack.setCount(containerStack.getCount() - takeAway);
                    if ((amountLeft -= takeAway) == 0) break;
                }
                return;
            }
            case 3: {
                FallenTimerEvent.revivePlayer(player, false);
                int seconds = (int)((double)(ReviveMeConfig.reviveKillTime * 20) * (1.0 - penaltyPercentage));
                int killCount = ReviveMeConfig.reviveKillAmount;
                player.addEffect(new MobEffectInstance(MobEffectInit.KILL_REVIVE_EFFECT, seconds, killCount - 1));
                return;
            }
            case 4: {
                double invulnTime = ReviveMeConfig.reviveInvulnTime;
                if (ReviveMeConfig.disableReviveEffects) {
                    ReviveMeConfig.reviveInvulnTime = 0.0;
                }
                FallenTimerEvent.revivePlayer(player, false);
                ReviveMeConfig.reviveInvulnTime = invulnTime;
                int amp = 0;
                int duration = (int)((double)(20 * ReviveMeConfig.negativeEffectsTime) * (1.0 + penaltyPercentage));
                if (this.negativeStatusEffects.size() == 1) {
                    amp = 1;
                }
                for (MobEffect effect : this.negativeStatusEffects) {
                    player.addEffect(new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, amp));
                }
                return;
            }
            case 5: {
                if (player.experienceLevel < ReviveMeConfig.minReviveXPLevel) break;
                FallenTimerEvent.revivePlayer(player, false);
                player.giveExperienceLevels((int)(-((double)player.experienceLevel * ReviveMeConfig.reviveXPLossPercentage * (1.0 + penaltyPercentage))));
                return;
            }
        }
        this.kill(player);
    }

    public void resetSelfReviveCount() {
        this.selfReviveCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void refreshSelfReviveTypes(Player player) {
        if (!this.selfReviveTypeList.containsAll(ReviveMeConfig.selfReviveOptions) || this.selfReviveTypeList.size() != ReviveMeConfig.selfReviveOptions.size()) {
            this.selfReviveTypeList = new ArrayList<SELFREVIVETYPE>(ReviveMeConfig.selfReviveOptions);
        }
        if (ReviveMeConfig.randomizeSelfReviveOptions) {
            Collections.shuffle(this.selfReviveTypeList);
        }
        if (this.selfReviveTypeList.contains((Object)SELFREVIVETYPE.RANDOM_ITEMS)) {
            this.setSacrificialItems(player.getInventory());
        }
        if (this.selfReviveTypeList.contains((Object)SELFREVIVETYPE.STATUS_EFFECTS)) {
            this.negativeStatusEffects.clear();
            this.negativeStatusEffects.addAll(CommonUtil.pickRandomObjectsFromList((int)(Math.random() > 0.5 ? 1 : 2), ReviveMeConfig.harmfulEffects));
        }
        int count = 0;
        if (!ReviveMeConfig.onlyUseAvailableOptions) return;
        int a = 0;
        while (a < this.selfReviveTypeList.size()) {
            block11: {
                if (count == 2) {
                    return;
                }
                switch (this.selfReviveTypeList.get(a).ordinal()) {
                    case 1: {
                        if (!this.getItemList().isEmpty()) break;
                        break block11;
                    }
                    case 2: {
                        if ((Integer)this.getSpecificItem(player).getKey() != 0) break;
                        break block11;
                    }
                    case 5: {
                        if (player.experienceLevel < ReviveMeConfig.minReviveXPLevel) break block11;
                    }
                }
                this.selfReviveTypeList.add(0, this.selfReviveTypeList.remove(a));
                ++count;
            }
            ++a;
        }
    }

    public Pair<Integer, List<ItemStack>> getSpecificItem(Player player) {
        ItemStack defaultStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)ReviveMeConfig.specificItem)));
        try {
            if (!ReviveMeConfig.specificItemData.isEmpty()) {
                defaultStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)ReviveMeConfig.specificItemData));
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        Inventory playerInv = player.getInventory();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int countNeeded = ReviveMeConfig.specificItemCount;
        int count = 0;
        for (int a = 0; a < playerInv.getContainerSize(); ++a) {
            ItemStack containerStack = playerInv.getItem(a);
            if (!ItemStack.isSameItem((ItemStack)containerStack, (ItemStack)defaultStack) || !FallenData.hasMatchingTags(containerStack, defaultStack)) continue;
            stackList.add(containerStack);
            if ((count += containerStack.getCount()) >= countNeeded) break;
        }
        if (count == 0) {
            stackList.add(defaultStack);
        }
        count = Math.min(count, countNeeded);
        return Pair.of((Object)count, stackList);
    }

    public List<MobEffect> getNegativeStatusEffects() {
        return new ArrayList<MobEffect>(this.negativeStatusEffects);
    }

    public double getSelfPenaltyPercentage() {
        return (double)this.getSelfReviveCount() * ReviveMeConfig.selfPenaltyPercentage;
    }

    public int getSelfReviveCount() {
        return this.selfReviveCount;
    }

    public void setSacrificialItems(Inventory inventory) {
        if (inventory == null) {
            return;
        }
        Pair<Integer, List<ItemStack>> specificPair = this.getSpecificItem(inventory.player);
        ArrayList<ItemStack> playerItems = new ArrayList<ItemStack>();
        for (int a = 0; a < inventory.items.size(); ++a) {
            ItemStack newStack;
            if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !(newStack = inventory.getItem(a)).isStackable() || ((List)specificPair.getValue()).contains(newStack) || playerItems.stream().anyMatch(listStack -> ItemStack.isSameItem((ItemStack)newStack, (ItemStack)listStack) && FallenData.hasMatchingTags(newStack, listStack)) || newStack.isEmpty()) continue;
            playerItems.add(this.level.random.nextInt(Math.max(1, playerItems.size())), newStack.copy());
        }
        while (playerItems.size() > 4) {
            playerItems.remove(this.level.random.nextInt(playerItems.size()));
        }
        this.sacrificialItems = playerItems;
    }

    public ArrayList<ItemStack> getItemList() {
        return new ArrayList<ItemStack>(this.sacrificialItems);
    }

    public boolean isSacrificialItem(ItemStack mainStack) {
        if (!this.canSelfRevive()) {
            return false;
        }
        return this.sacrificialItems.stream().anyMatch(sacrificialStack -> ItemStack.isSameItem((ItemStack)mainStack, (ItemStack)sacrificialStack) && FallenData.hasMatchingTags(mainStack, sacrificialStack));
    }

    public static int countItem(Inventory inventory, ItemStack sacrificialStack) {
        int count = 0;
        for (int a = 0; a < inventory.getContainerSize(); ++a) {
            ItemStack containerStack;
            if (!ReviveMeConfig.sacrificialItemTakesHotbar && (a < 9 || a == 40) || !ItemStack.isSameItem((ItemStack)sacrificialStack, (ItemStack)(containerStack = inventory.getItem(a))) || !FallenData.hasMatchingTags(sacrificialStack, containerStack)) continue;
            count += containerStack.getCount();
        }
        return count;
    }

    public int getPenaltyMultiplier() {
        return this.penaltyMultiplier;
    }

    public long getPenaltyTicks(double ticks) {
        double multiplier = (double)this.getPenaltyMultiplier() * ReviveMeConfig.timeReductionPenalty;
        if (ReviveMeConfig.timeReductionPenalty == -1.0) {
            multiplier = (double)this.getPenaltyMultiplier() * ticks;
        } else if (ReviveMeConfig.timeReductionPenalty < 1.0) {
            multiplier *= ticks;
        } else if (ReviveMeConfig.timeReductionPenalty >= 1.0) {
            multiplier *= 20.0;
        }
        return (long)Math.max(0.0, ticks - multiplier);
    }

    public void setPenaltyMultiplier(int newMultiplier) {
        this.penaltyMultiplier = newMultiplier;
    }

    public void saveEffects(Player player) {
        CompoundTag effectsTag = new CompoundTag();
        for (MobEffectInstance effectInstance : new ArrayList(player.getActiveEffects())) {
            if (effectInstance.getDuration() <= 20) continue;
            Tag savedEffectTag = effectInstance.save();
            effectsTag.put("" + effectsTag.size(), savedEffectTag);
        }
        this.savedEffectsTag = effectsTag;
    }

    public void loadEffects(Player player) {
        for (String key : this.savedEffectsTag.getAllKeys()) {
            MobEffectInstance instance = MobEffectInstance.load((CompoundTag)this.savedEffectsTag.getCompound(key));
            if (instance == null) continue;
            player.addEffect(instance);
        }
        this.savedEffectsTag = new CompoundTag();
    }

    public CompoundTag writeNBT() {
        CompoundTag cNBT = new CompoundTag();
        cNBT.putLong(FELL_START_LONG, this.fellStart);
        cNBT.putDouble(FELL_END_DOUBLE, this.fellEnd / 20.0);
        cNBT.putBoolean(FALLEN_BOOL, this.isFallen);
        cNBT.putLong(REVIVE_START_LONG, this.revStart);
        cNBT.putInt(REVIVE_END_INT, this.revEnd / 20);
        String selfReviveListString = "";
        for (SELFREVIVETYPE selfrevivetype : this.selfReviveTypeList) {
            selfReviveListString = selfReviveListString.concat(selfrevivetype.name() + ",");
        }
        cNBT.putString(SELF_REVIVE_OPTIONS_STRING, selfReviveListString);
        CompoundTag statusEffectNBT = new CompoundTag();
        int count = 0;
        ItemStack s = new ItemStack((ItemLike)Items.GOLD_BLOCK);
        ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)s).getOrThrow();
        for (MobEffect effect : this.negativeStatusEffects) {
            statusEffectNBT.put("" + count, (Tag)MobEffect.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect)).getOrThrow());
            ++count;
        }
        cNBT.put(STATUS_EFFECTS_COMPOUND, (Tag)statusEffectNBT);
        CompoundTag itemCompound = new CompoundTag();
        for (ItemStack item : this.sacrificialItems) {
            itemCompound.put("" + itemCompound.size(), item.save(this.provider));
        }
        cNBT.put(SACRIFICEITEMS_COMPOUND, (Tag)itemCompound);
        cNBT.putInt(PENALTY_MULTIPLIER_INT, this.penaltyMultiplier);
        cNBT.putLong(CALLED_FOR_HELP_LONG, this.calledForHelpTime);
        cNBT.put(SAVED_EFFECTS_TAG, (Tag)this.savedEffectsTag);
        if (this.otherPlayer != null) {
            cNBT.putUUID(OTHERPLAYER_UUID, this.otherPlayer);
        }
        cNBT.putInt(SELF_REVIVE_COUNT_INT, this.selfReviveCount);
        cNBT.putBoolean(DOWNED_BY_PLAYER_BOOL, this.isDownedByPlayer());
        cNBT.putBoolean(IS_EFFECTS_REMOVED, this.isEffectsRemoved);
        return cNBT;
    }

    public void readNBT(Tag nbt) {
        CompoundTag cNBT = (CompoundTag)nbt;
        this.SetTimeLeft(cNBT.getLong(FELL_START_LONG), cNBT.getDouble(FELL_END_DOUBLE));
        this.setFallen(cNBT.getBoolean(FALLEN_BOOL));
        this.setProgress(cNBT.getLong(REVIVE_START_LONG), cNBT.getInt(REVIVE_END_INT));
        this.selfReviveTypeList.clear();
        for (String s : cNBT.getString(SELF_REVIVE_OPTIONS_STRING).split(",")) {
            try {
                this.selfReviveTypeList.add(SELFREVIVETYPE.valueOf(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.selfReviveTypeList.isEmpty()) {
            this.selfReviveTypeList.addAll(ReviveMeConfig.selfReviveOptions);
        }
        this.negativeStatusEffects.clear();
        CompoundTag statusEffectNBT = cNBT.getCompound(STATUS_EFFECTS_COMPOUND);
        for (String s : statusEffectNBT.getAllKeys()) {
            try {
                this.negativeStatusEffects.add((MobEffect)((Holder)MobEffect.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)statusEffectNBT.get(s)).getOrThrow()).value());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.sacrificialItems.clear();
        CompoundTag itemCompound = cNBT.getCompound(SACRIFICEITEMS_COMPOUND);
        if (!itemCompound.isEmpty()) {
            for (String key : itemCompound.getAllKeys()) {
                Optional optional = ItemStack.parse((HolderLookup.Provider)this.provider, (Tag)itemCompound.getCompound(key));
                if (optional.isEmpty()) continue;
                ItemStack sacrificeStack = (ItemStack)optional.get();
                this.sacrificialItems.add(sacrificeStack);
            }
        }
        this.penaltyMultiplier = cNBT.getInt(PENALTY_MULTIPLIER_INT);
        this.calledForHelpTime = cNBT.getLong(CALLED_FOR_HELP_LONG);
        this.savedEffectsTag = cNBT.getCompound(SAVED_EFFECTS_TAG);
        if (cNBT.hasUUID(OTHERPLAYER_UUID)) {
            this.setOtherPlayer(cNBT.getUUID(OTHERPLAYER_UUID));
        } else {
            this.setOtherPlayer(null);
        }
        this.selfReviveCount = cNBT.getInt(SELF_REVIVE_COUNT_INT);
        this.isDownedByPlayer = cNBT.getBoolean(DOWNED_BY_PLAYER_BOOL);
        this.isEffectsRemoved = cNBT.getBoolean(IS_EFFECTS_REMOVED);
    }

    public static enum PENALTYPE {
        NONE,
        HEALTH,
        EXPERIENCE,
        FOOD,
        ITEM;

    }

    public static enum SELFREVIVETYPE {
        CHANCE,
        RANDOM_ITEMS,
        SPECIFIC_ITEM,
        KILL,
        STATUS_EFFECTS,
        EXPERIENCE;

    }
}

