/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import invoker54.invocore.client.util.InvoText;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.event.FallenTimerEvent;
import invoker54.reviveme.init.NetworkInit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ReviveCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reviveme").requires(commandSource -> commandSource.hasPermission(2))).executes(ReviveCommand::revivePlayer)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ReviveCommand::revivePlayer)));
    }

    private static int revivePlayer(CommandContext<CommandSourceStack> commandContext) {
        ServerPlayer caller;
        try {
            caller = EntityArgument.getPlayer(commandContext, (String)"player");
        }
        catch (Exception e) {
            if (!((CommandSourceStack)commandContext.getSource()).isPlayer()) {
                return 1;
            }
            caller = ((CommandSourceStack)commandContext.getSource()).getPlayer();
        }
        FallenData cap = FallenData.get((LivingEntity)caller);
        if (caller.isDeadOrDying() || !cap.isFallen()) {
            caller.server.getPlayerList().broadcastSystemMessage((Component)caller.getDisplayName().copy().append((Component)Component.translatable((String)"revive_me.commands.revive_fail")), false);
            return 1;
        }
        if (caller.isDeadOrDying() || !cap.isFallen()) {
            InvoText failTxt = InvoText.translate((String)"revive_me.commands.revive_fail", (Object[])new Object[]{caller.getDisplayName()});
            NetworkInit.sendMessage(failTxt.getText(), true, (Entity)caller);
            return 1;
        }
        FallenTimerEvent.revivePlayer((Player)caller, true);
        return 1;
    }
}

