/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class CircleRender {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void drawArc(PoseStack stack, float origX, float origY, double radius, double startAngle, double endAngle, int colorCode) {
        stack.pushPose();
        Matrix4f lastPos = stack.last().pose();
        double angleIncrement = Math.toRadians(5.0);
        float direction = endAngle >= startAngle ? 1.0f : -1.0f;
        double deltaAngle = Math.abs(endAngle - startAngle);
        deltaAngle = (deltaAngle %= 360.0) == 0.0 ? 360.0 : deltaAngle;
        startAngle = direction < 0.0f ? endAngle : startAngle;
        startAngle -= Math.floor(startAngle / 360.0);
        startAngle = Math.toRadians(startAngle);
        deltaAngle = Math.toRadians(deltaAngle);
        double arcPos = 0.0;
        boolean arcFinished = false;
        float f3 = (float)(colorCode >> 24 & 0xFF) / 255.0f;
        float f = (float)(colorCode >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(colorCode >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(colorCode & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (deltaAngle < 360.0) {
            bufferbuilder.addVertex(lastPos, origX, origY, 0.0f).setColor(f, f1, f2, f3);
        }
        do {
            double truncAngle = Math.min(arcPos, deltaAngle);
            double x = (double)origX + radius * Math.sin(startAngle + (double)direction * truncAngle);
            double y = (double)origY + -radius * Math.cos(startAngle + truncAngle);
            bufferbuilder.addVertex(lastPos, (float)x, (float)y, 0.0f).setColor(f, f1, f2, f3);
        } while (!(arcFinished = arcPos >= deltaAngle) && (arcPos += angleIncrement) <= Math.toRadians(360.0));
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        stack.popPose();
    }

    public static void drawArcWorld(PoseStack stack, Vector3d origin, double radius, double startAngle, double endAngle, int colorCode) {
        Matrix4f lastPos = stack.last().pose();
        double angleIncrement = Math.toRadians(5.0);
        float direction = endAngle >= startAngle ? -1.0f : 1.0f;
        double deltaAngle = Math.abs(endAngle - startAngle);
        deltaAngle %= 360.0;
        startAngle -= Math.floor(startAngle / 360.0);
        startAngle = Math.toRadians(startAngle);
        deltaAngle = Math.toRadians(deltaAngle);
        double arcPos = 0.0;
        boolean arcFinished = false;
        float f3 = (float)(colorCode >> 24 & 0xFF) / 255.0f;
        float f = (float)(colorCode >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(colorCode >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(colorCode & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        if (Math.abs(endAngle - startAngle) < 360.0) {
            bufferbuilder.addVertex(lastPos, (float)origin.x, (float)origin.y, (float)origin.z).setColor(f, f1, f2, f3);
        }
        do {
            double truncAngle = Math.min(arcPos, deltaAngle);
            double x = origin.x + radius * Math.sin(startAngle + (double)direction * truncAngle);
            double y = origin.y + -radius * Math.cos(startAngle + (double)direction * truncAngle);
            bufferbuilder.addVertex(lastPos, (float)x, (float)y, (float)origin.z).setColor(f, f1, f2, f3);
        } while (!(arcFinished = arcPos >= deltaAngle) && (arcPos += angleIncrement) <= Math.toRadians(360.0));
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

