/*
 * Decompiled with CFR 0.152.
 */
package invoker54.reviveme.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import invoker54.invocore.client.util.ClientUtil;
import invoker54.invocore.client.util.InvoText;
import invoker54.invocore.client.util.InvoZone;
import invoker54.invocore.client.util.TextUtil;
import invoker54.reviveme.client.VanillaKeybindHandler;
import invoker54.reviveme.client.event.FallScreenEvent;
import invoker54.reviveme.client.event.ReviveScreenEvent;
import invoker54.reviveme.client.gui.render.CircleRender;
import invoker54.reviveme.common.capability.FallenData;
import invoker54.reviveme.common.config.ReviveMeConfig;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="revive_me", value={Dist.CLIENT})
public class RenderFallPlateEvent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Minecraft inst = Minecraft.getInstance();
    public static final DecimalFormat df = new DecimalFormat("0.0");
    public static final int greenProgCircle = new Color(39, 235, 86, 255).getRGB();
    public static final int redProgCircle = new Color(173, 17, 17, 255).getRGB();
    public static final int blackBg = new Color(0, 0, 0, 176).getRGB();

    @SubscribeEvent
    public static void renderWorldFallTimer(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mC = ClientUtil.getMinecraft();
        for (Entity entity : RenderFallPlateEvent.inst.level.entitiesForRendering()) {
            boolean targetSeen;
            double maxDistance;
            float distance;
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (entity.equals((Object)mC.player) || (double)(distance = entity.distanceTo((Entity)mC.player)) > (maxDistance = Math.max(ReviveMeConfig.reviveGlowMaxDistance, ReviveMeConfig.deathTimerMaxDistance))) continue;
            FallenData cap = FallenData.get((LivingEntity)player);
            PoseStack stack = event.getPoseStack();
            if (!cap.isFallen()) continue;
            BlockHitResult rayResult = mC.player.level().clip(new ClipContext(mC.player.getEyePosition(1.0f), entity.getEyePosition(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
            boolean bl = targetSeen = rayResult.getType() == HitResult.Type.MISS;
            if (distance > 10.0f && !cap.isCallingForHelp() && !targetSeen) continue;
            float yOffset = entity.getBbHeight() * 0.4f;
            float sizeOffset = 0.5f;
            if (distance > 10.0f) {
                float distanceOffset = distance - 10.0f;
                yOffset = entity.getBbHeight() * 1.4f + distanceOffset * 0.03f;
                sizeOffset += distanceOffset * 0.05f;
            }
            stack.pushPose();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            Vec3 difference = entity.position().subtract(mC.gameRenderer.getMainCamera().getPosition());
            stack.translate(difference.x, difference.y + (double)yOffset, difference.z);
            stack.mulPose(mC.getEntityRenderDispatcher().cameraOrientation());
            stack.scale(0.025f, -0.025f, 0.025f);
            stack.scale(sizeOffset, sizeOffset, sizeOffset);
            if (cap.getOtherPlayer() == null) {
                radius = 22;
                InvoText chosenText = null;
                int chosenColor = 0;
                boolean canRender = false;
                if (!mC.player.isCrouching() && !player.isDeadOrDying()) {
                    float seconds;
                    canRender = true;
                    chosenColor = greenProgCircle;
                    chosenText = InvoText.literal((String)(seconds <= 0.0f ? "INF" : Integer.toString((int)(seconds += (float)(!((seconds = cap.GetTimeLeft(false)) <= 0.0f) ? 1 : 0))))).withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD}).withStyle(false, new ChatFormatting[]{cap.hasEnough((Player)RenderFallPlateEvent.inst.player) ? ChatFormatting.GREEN : ChatFormatting.RED});
                } else if (mC.player.isCrouching() || player.isDeadOrDying()) {
                    canRender = true;
                    chosenColor = redProgCircle;
                    chosenText = InvoText.literal((String)Integer.toString((int)Math.ceil(cap.getKillTime(false)))).withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED});
                }
                if (canRender && (double)distance < ReviveMeConfig.deathTimerMaxDistance) {
                    float endAngle = 360.0f;
                    if (RenderFallPlateEvent.inst.player.isCrouching()) {
                        endAngle *= cap.getKillTime(true);
                    } else if (ReviveMeConfig.timeLeft != 0) {
                        endAngle *= cap.GetTimeLeft(true);
                    }
                    if (cap.GetTimeLeft(false) <= 0.0f) {
                        CircleRender.drawArc(stack, 0.0f, 0.0f, radius, 0.0, endAngle, chosenColor);
                    } else {
                        CircleRender.drawArc(stack, 0.0f, 0.0f, radius, 0.0, endAngle, chosenColor);
                    }
                    InvoZone timerZone = FallScreenEvent.timerIMG.getRenderZone();
                    timerZone.setHeight(40.0f).setWidth(40.0f);
                    timerZone.centerX(0.0f).centerY(0.0f);
                    FallScreenEvent.timerIMG.render(stack);
                    TextUtil.renderText((PoseStack)stack, (Component)chosenText.getText(), (boolean)false, (int)1, (InvoZone)timerZone.inflate(-timerZone.width() / 4.0f, -timerZone.height() / 4.0f), (TextUtil.txtAlignment)TextUtil.txtAlignment.MIDDLE);
                }
                InvoText message = null;
                if (mC.crosshairPickEntity == player && !player.isDeadOrDying()) {
                    if (mC.player.isCrouching()) {
                        message = cap.getKillTime(false) > 0.0f ? InvoText.translate((String)"revive_me.fall_plate.cant_kill", (Object[])new Object[0]) : InvoText.translate((String)"revive_me.fall_plate.kill", (Object[])new Object[0]).setArgs(new Object[]{InvoText.literal((String)VanillaKeybindHandler.getKey(RenderFallPlateEvent.inst.options.keyAttack).getDisplayName().getString()).withStyle(true, new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).getText()});
                    } else if (cap.hasEnough((Player)mC.player)) {
                        message = InvoText.translate((String)"revive_me.fall_plate.revive", (Object[])new Object[0]).setArgs(new Object[]{InvoText.literal((String)VanillaKeybindHandler.getKey(RenderFallPlateEvent.inst.options.keyUse).getDisplayName().getString()).withStyle(true, new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).getText()});
                    }
                }
                if (message == null && cap.isCallingForHelp()) {
                    message = InvoText.literal((String)"").append(InvoText.literal((String)"ABBA ").withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED, ChatFormatting.OBFUSCATED})).append((Component)InvoText.literal((String)"[").withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD}).getText()).append(InvoText.translate((String)"revive_me.call_for_help", (Object[])new Object[0]).withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD})).append(InvoText.literal((String)"]").withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD})).append(InvoText.literal((String)" ABBA").withStyle(true, new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED, ChatFormatting.OBFUSCATED}));
                }
                if (message != null) {
                    int txtWidth = mC.font.width((FormattedText)message.getText());
                    int padding = 2;
                    int width = txtWidth + padding * 2;
                    Objects.requireNonNull(mC.font);
                    int height = 9 + padding * 2;
                    int x0 = -width / 2;
                    int y0 = -(height + radius);
                    InvoZone txtZone = new InvoZone((float)x0, (float)width, (float)y0, (float)height);
                    if ((double)distance > ReviveMeConfig.deathTimerMaxDistance) {
                        txtZone.setY(0.0f);
                    }
                    ClientUtil.blitColor((PoseStack)stack, (InvoZone)txtZone, (int)blackBg);
                    TextUtil.renderText((PoseStack)stack, (Component)message.getText(), (boolean)false, (int)1, (InvoZone)txtZone.inflate(-2.0f, -2.0f), (TextUtil.txtAlignment)TextUtil.txtAlignment.MIDDLE);
                }
            } else if (!mC.player.getUUID().equals(cap.getOtherPlayer()) && (double)distance < ReviveMeConfig.deathTimerMaxDistance) {
                radius = 20;
                InvoText message = ReviveScreenEvent.beingRevivedText;
                int txtWidth = mC.font.width((FormattedText)message.getText());
                int padding = 1;
                int width = txtWidth + padding * 2;
                Objects.requireNonNull(mC.font);
                int height = 9 + padding * 2;
                ClientUtil.blitColor((PoseStack)stack, (float)(-width / 2), (float)width, (float)(-(height + radius)), (float)height, (int)blackBg);
                Objects.requireNonNull(mC.font);
                height = 9;
                TextUtil.renderText((FormattedText)message.getText(), (PoseStack)stack, (float)((float)(-txtWidth) / 2.0f), (float)(-(height + radius + padding)), (boolean)false);
                InvoZone progressZone = new InvoZone(0.0f, 40.0f, -5.0f, 10.0f);
                progressZone.centerX(0.0f);
                ClientUtil.blitColor((PoseStack)stack, (InvoZone)progressZone, (int)ReviveScreenEvent.bgColor);
                float progress = cap.getProgress(true);
                progressZone.inflate(-1.0f, -1.0f).setWidth(progressZone.width() * progress);
                progressZone.centerX(0.0f);
                ClientUtil.blitColor((PoseStack)stack, (InvoZone)progressZone, (int)ReviveScreenEvent.progressColor);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            stack.popPose();
        }
    }
}

