/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonBaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;

public class ReinforcedPistonStructureResolver {
    private final Level level;
    private final BlockPos pistonPos;
    private final boolean extending;
    private final BlockPos startPos;
    private final Direction pushDirection;
    private final List<BlockPos> toPush = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private final Direction pistonDirection;

    public ReinforcedPistonStructureResolver(Level level, BlockPos pos, Direction pistonFacing, boolean extending) {
        this.level = level;
        this.pistonPos = pos;
        this.pistonDirection = pistonFacing;
        this.extending = extending;
        if (extending) {
            this.pushDirection = pistonFacing;
            this.startPos = pos.relative(pistonFacing);
        } else {
            this.pushDirection = pistonFacing.getOpposite();
            this.startPos = pos.relative(pistonFacing, 2);
        }
    }

    public boolean resolve() {
        BlockState state = this.level.getBlockState(this.startPos);
        this.toPush.clear();
        this.toDestroy.clear();
        if (!ReinforcedPistonBaseBlock.isPushable(state, this.level, this.pistonPos, this.startPos, this.pushDirection, false, this.pistonDirection)) {
            if (this.extending && state.getPistonPushReaction() == PushReaction.DESTROY) {
                this.toDestroy.add(this.startPos);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.startPos, this.pushDirection)) {
            return false;
        }
        for (int i = 0; i < this.toPush.size(); ++i) {
            BlockPos pos = this.toPush.get(i);
            if (!this.level.getBlockState(pos).isStickyBlock() || this.addBranchingBlocks(pos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos originPos, Direction facing) {
        BlockState state = this.level.getBlockState(originPos);
        if (this.level.isEmptyBlock(originPos)) {
            return true;
        }
        if (!ReinforcedPistonBaseBlock.isPushable(state, this.level, this.pistonPos, originPos, this.pushDirection, false, facing)) {
            return true;
        }
        if (originPos.equals((Object)this.pistonPos)) {
            return true;
        }
        if (this.toPush.contains(originPos)) {
            return true;
        }
        int i = 1;
        if (i + this.toPush.size() > 12) {
            return false;
        }
        while (state.isStickyBlock()) {
            BlockPos offsetPos = originPos.relative(this.pushDirection.getOpposite(), i);
            BlockState oldState = state;
            state = this.level.getBlockState(offsetPos);
            if (state.isAir() || !oldState.canStickTo(state) || !ReinforcedPistonBaseBlock.isPushable(state, this.level, this.pistonPos, offsetPos, this.pushDirection, false, this.pushDirection.getOpposite()) || offsetPos.equals((Object)this.pistonPos)) break;
            if (++i + this.toPush.size() <= 12) continue;
            return false;
        }
        int l = 0;
        for (int i1 = i - 1; i1 >= 0; --i1) {
            this.toPush.add(originPos.relative(this.pushDirection.getOpposite(), i1));
            ++l;
        }
        int j1 = 1;
        while (true) {
            BlockPos offsetPos;
            int j;
            if ((j = this.toPush.indexOf(offsetPos = originPos.relative(this.pushDirection, j1))) > -1) {
                this.reorderListAtCollision(l, j);
                for (int k = 0; k <= j + l; ++k) {
                    BlockPos posToPush = this.toPush.get(k);
                    if (!this.level.getBlockState(posToPush).isStickyBlock() || this.addBranchingBlocks(posToPush)) continue;
                    return false;
                }
                return true;
            }
            state = this.level.getBlockState(offsetPos);
            if (state.isAir()) {
                return true;
            }
            if (!ReinforcedPistonBaseBlock.isPushable(state, this.level, this.pistonPos, offsetPos, this.pushDirection, true, this.pushDirection) || offsetPos.equals((Object)this.pistonPos)) {
                return false;
            }
            if (state.getPistonPushReaction() == PushReaction.DESTROY) {
                this.toDestroy.add(offsetPos);
                return true;
            }
            if (this.toPush.size() >= 12) {
                return false;
            }
            this.toPush.add(offsetPos);
            ++l;
            ++j1;
        }
    }

    private void reorderListAtCollision(int offsets, int index) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toPush.subList(0, index));
        list1.addAll(this.toPush.subList(this.toPush.size() - offsets, this.toPush.size()));
        list2.addAll(this.toPush.subList(index, this.toPush.size() - offsets));
        this.toPush.clear();
        this.toPush.addAll(list);
        this.toPush.addAll(list1);
        this.toPush.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos fromPos) {
        BlockState state = this.level.getBlockState(fromPos);
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos;
            BlockState offsetState;
            if (direction.getAxis() == this.pushDirection.getAxis() || !(offsetState = this.level.getBlockState(offsetPos = fromPos.relative(direction))).canStickTo(state) || this.addBlockLine(offsetPos, direction)) continue;
            return false;
        }
        return true;
    }

    public Direction getPushDirection() {
        return this.pushDirection;
    }

    public List<BlockPos> getToPush() {
        return this.toPush;
    }

    public List<BlockPos> getToDestroy() {
        return this.toDestroy;
    }
}

