/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class LevelUtils {
    private LevelUtils() {
    }

    public static void addScheduledTask(LevelAccessor level, Runnable runnable) {
        if (level.isClientSide()) {
            Minecraft.getInstance().execute(runnable);
        } else {
            ServerLifecycleHooks.getCurrentServer().execute(runnable);
        }
    }

    public static LightningBolt createLightning(Level level, Vec3 pos, boolean effectOnly) {
        LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
        lightning.moveTo(pos);
        lightning.setVisualOnly(effectOnly);
        return lightning;
    }

    public static boolean checkCoordinates(GlobalPos pos, String[] coordinates) {
        int xPos = Integer.parseInt(coordinates[0]);
        int yPos = Integer.parseInt(coordinates[1]);
        int zPos = Integer.parseInt(coordinates[2]);
        ResourceLocation dim = SecurityCraft.mcResLoc(coordinates.length == 4 ? coordinates[3] : "");
        return pos.pos().getX() == xPos && pos.pos().getY() == yPos && pos.pos().getZ() == zPos && pos.dimension().location().equals((Object)dim);
    }

    public static String toNBTString(GlobalPos pos) {
        return pos.pos().getX() + " " + pos.pos().getY() + " " + pos.pos().getZ() + " " + String.valueOf(pos.dimension().location());
    }

    public static void blockEntityTicker(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ((ITickingBlockEntity)blockEntity).tick(level, pos, state);
    }
}

