/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonMovingBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonHeadBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ClientHooks;

public class ReinforcedPistonHeadRenderer
implements BlockEntityRenderer<ReinforcedPistonMovingBlockEntity> {
    private BlockRenderDispatcher blockRenderer;

    public ReinforcedPistonHeadRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderer = ctx.getBlockRenderDispatcher();
    }

    public void render(ReinforcedPistonMovingBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level = be.getLevel();
        if (level != null) {
            BlockPos oppositePos = be.getBlockPos().relative(be.getMovementDirection().getOpposite());
            BlockState state = be.getMovedState();
            if (!state.isAir()) {
                ModelBlockRenderer.enableCaching();
                poseStack.pushPose();
                poseStack.translate(be.getOffsetX(partialTicks), be.getOffsetY(partialTicks), be.getOffsetZ(partialTicks));
                if (state.is((Block)SCContent.REINFORCED_PISTON_HEAD.get()) && be.getProgress(partialTicks) <= 4.0f) {
                    state = (BlockState)state.setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(be.getProgress(partialTicks) <= 0.5f));
                    this.renderBlocks(oppositePos, state, poseStack, buffer, level, false, combinedOverlay);
                } else if (be.isSourcePiston() && !be.isExtending()) {
                    PistonType pistonType = state.is((Block)SCContent.REINFORCED_STICKY_PISTON.get()) ? PistonType.STICKY : PistonType.DEFAULT;
                    BlockState headState = (BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).defaultBlockState().setValue((Property)PistonHeadBlock.TYPE, (Comparable)pistonType)).setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING)));
                    BlockPos renderPos = oppositePos.relative(be.getMovementDirection());
                    headState = (BlockState)headState.setValue((Property)PistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(be.getProgress(partialTicks) >= 0.5f));
                    this.renderBlocks(oppositePos, headState, poseStack, buffer, level, false, combinedOverlay);
                    poseStack.popPose();
                    poseStack.pushPose();
                    state = (BlockState)state.setValue((Property)PistonBaseBlock.EXTENDED, (Comparable)Boolean.valueOf(true));
                    this.renderBlocks(renderPos, state, poseStack, buffer, level, true, combinedOverlay);
                } else {
                    this.renderBlocks(oppositePos, state, poseStack, buffer, level, false, combinedOverlay);
                }
                poseStack.popPose();
                ModelBlockRenderer.clearCache();
            }
        }
    }

    private void renderBlocks(BlockPos pos, BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, boolean checkSides, int combinedOverlay) {
        if (this.blockRenderer == null) {
            this.blockRenderer = Minecraft.getInstance().getBlockRenderer();
        }
        ClientHooks.renderPistonMovedBlocks((BlockPos)pos, (BlockState)state, (PoseStack)poseStack, (MultiBufferSource)buffer, (Level)level, (boolean)checkSides, (int)combinedOverlay, (BlockRenderDispatcher)this.blockRenderer);
    }

    public int getViewDistance() {
        return 68;
    }
}

