/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TaserItem
extends Item {
    private boolean powered;

    public TaserItem(Item.Properties properties, boolean isPowered) {
        super(properties);
        this.powered = isPowered;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.isDamaged()) return InteractionResultHolder.pass((Object)stack);
        if (player.isCrouching() && (player.isCreative() || !this.powered)) {
            ItemStack redstoneStack;
            ItemStack oneRedstone = new ItemStack((ItemLike)Items.REDSTONE, 1);
            if (player.isCreative()) {
                if (player.getItemInHand(hand).getItem() == SCContent.TASER.get()) {
                    player.setItemInHand(hand, new ItemStack((ItemLike)SCContent.TASER_POWERED.get(), 1));
                    return InteractionResultHolder.success((Object)stack);
                } else {
                    player.setItemInHand(hand, new ItemStack((ItemLike)SCContent.TASER.get(), 1));
                }
                return InteractionResultHolder.success((Object)stack);
            }
            if (!player.getInventory().contains(oneRedstone)) return InteractionResultHolder.pass((Object)stack);
            int redstoneSlot = player.getInventory().findSlotMatchingUnusedItem(oneRedstone);
            if (redstoneSlot == -1) {
                if (player.getOffhandItem().getItem() != Items.REDSTONE) return InteractionResultHolder.pass((Object)stack);
                redstoneStack = player.getOffhandItem();
            } else {
                redstoneStack = player.getInventory().getItem(redstoneSlot);
            }
            redstoneStack.setCount(redstoneStack.getCount() - 1);
            if (redstoneSlot == -1) {
                player.getInventory().offhand.set(0, (Object)redstoneStack);
            } else {
                player.getInventory().setItem(redstoneSlot, redstoneStack);
            }
            player.setItemInHand(hand, new ItemStack((ItemLike)SCContent.TASER_POWERED.get(), 1));
            return InteractionResultHolder.success((Object)stack);
        }
        int range = 11;
        Vec3 startVec = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getViewVector(1.0f).scale((double)range);
        Vec3 endVec = startVec.add(lookVec);
        AABB boundingBox = player.getBoundingBox().expandTowards(lookVec).inflate(1.0, 1.0, 1.0);
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)startVec, (Vec3)endVec, (AABB)boundingBox, LivingEntity.class::isInstance, (double)(range * range));
        level.playSound(player, player.blockPosition(), SCSounds.TASERFIRED.event, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.PROJECTILE_SHOOT, player.blockPosition());
        if (hitResult != null) {
            LivingEntity entity = (LivingEntity)hitResult.getEntity();
            double damage = this.powered ? (Double)ConfigHandler.SERVER.poweredTaserDamage.get() : (Double)ConfigHandler.SERVER.taserDamage.get();
            if ((damage == 0.0 || entity.hurt(CustomDamageSources.taser((Entity)player), (float)damage)) && !entity.isBlocking()) {
                List effects = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects();
                effects.forEach(arg_0 -> ((LivingEntity)entity).addEffect(arg_0));
            }
        }
        if (player.isCreative()) return InteractionResultHolder.consume((Object)stack);
        if (this.powered) {
            ItemStack taser = new ItemStack((ItemLike)SCContent.TASER.get(), 1);
            taser.hurtAndBreak(150, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            player.setItemInHand(hand, taser);
            return InteractionResultHolder.consume((Object)stack);
        } else {
            stack.hurtAndBreak(150, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotIndex, boolean isSelected) {
        if (!level.isClientSide && stack.getDamageValue() >= 1) {
            stack.setDamageValue(stack.getDamageValue() - 1);
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public static PotionContents getDefaultEffects() {
        PotionContents effects = new PotionContents(Potions.WATER);
        effects = effects.withEffectAdded(new MobEffectInstance(MobEffects.WEAKNESS, 200, 1));
        effects = effects.withEffectAdded(new MobEffectInstance(MobEffects.CONFUSION, 200, 1));
        effects = effects.withEffectAdded(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1));
        return effects;
    }

    public static PotionContents getDefaultPoweredEffects() {
        PotionContents effects = new PotionContents(Potions.WATER);
        effects = effects.withEffectAdded(new MobEffectInstance(MobEffects.WEAKNESS, 400, 4));
        effects = effects.withEffectAdded(new MobEffectInstance(MobEffects.CONFUSION, 400, 4));
        effects = effects.withEffectAdded(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 4));
        return effects;
    }
}

