/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.GlobalPositions;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MineRemoteAccessToolItem
extends Item {
    public static final int MAX_MINES = 6;
    public static final GlobalPositions DEFAULT_POSITIONS = GlobalPositions.sized(6);

    public MineRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            ClientHandler.displayMRATScreen(player.getItemInHand(hand));
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        if (level.getBlockState(pos = ctx.getClickedPos()).getBlock() instanceof IExplosive) {
            IOwnable ownable;
            Player player = ctx.getPlayer();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IOwnable && !(ownable = (IOwnable)blockEntity).isOwnedBy((Entity)player)) {
                if (level.isClientSide) {
                    ClientHandler.displayMRATScreen(stack);
                }
                return InteractionResult.SUCCESS;
            }
            GlobalPositions positions = (GlobalPositions)stack.get(SCContent.BOUND_MINES);
            if (positions != null) {
                GlobalPos globalPos = new GlobalPos(level.dimension(), pos);
                if (positions.remove(SCContent.BOUND_MINES, stack, globalPos)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((MineRemoteAccessToolItem)((Object)SCContent.MINE_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:mrat.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
                } else if (positions.add((Supplier<DataComponentType<GlobalPositions>>)SCContent.BOUND_MINES, stack, globalPos)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((MineRemoteAccessToolItem)((Object)SCContent.MINE_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:mrat.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((MineRemoteAccessToolItem)((Object)SCContent.MINE_REMOTE_ACCESS_TOOL.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        GlobalPositions positions = (GlobalPositions)stack.get(SCContent.BOUND_MINES);
        if (positions != null && !positions.isEmpty()) {
            List<GlobalPos> globalPositions = positions.positions();
            for (int i = 0; i < globalPositions.size(); ++i) {
                GlobalPos globalPos = globalPositions.get(i);
                if (globalPos == null) {
                    list.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "---")));
                    continue;
                }
                list.add((Component)Utils.localize("tooltip.securitycraft:mine", i, Utils.getFormattedCoordinates(globalPos.pos())).setStyle(Utils.GRAY_STYLE));
            }
        }
    }
}

