/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record CodebreakerData(long lastUsedTime, boolean wasSuccessful) {
    public static final CodebreakerData DEFAULT = new CodebreakerData(0L, true);
    public static final Codec<CodebreakerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("last_used_time").forGetter(CodebreakerData::lastUsedTime), (App)Codec.BOOL.fieldOf("was_successful").forGetter(CodebreakerData::wasSuccessful)).apply((Applicative)instance, CodebreakerData::new));
    public static final StreamCodec<ByteBuf, CodebreakerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, CodebreakerData::lastUsedTime, (StreamCodec)ByteBufCodecs.BOOL, CodebreakerData::wasSuccessful, CodebreakerData::new);

    public boolean wasRecentlyUsed() {
        return this.lastUsedTime != 0L && System.currentTimeMillis() - this.lastUsedTime < 3000L;
    }
}

