/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadTrapdoorBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

public class KeypadTrapDoorBlock
extends BaseIronTrapDoorBlock
implements IDisguisable,
IOverlayDisplay {
    public KeypadTrapDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties, blockSetType);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return super.getShape(state, level, pos, ctx);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                return Shapes.empty();
            }
            return disguisedState.getShape(level, pos, ctx);
        }
        return super.getShape(state, level, pos, ctx);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        KeypadTrapdoorBlockEntity be = (KeypadTrapdoorBlockEntity)level.getBlockEntity(pos);
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && be.getSignalLength() > 0) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            if (be.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)OPEN));
        this.playSound(null, level, pos, true);
        if (signalLength > 0) {
            level.scheduleTick(pos, (Block)this, signalLength);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
            this.playSound(null, (Level)level, pos, false);
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof IPasscodeProtected) {
            IPasscodeProtected be = (IPasscodeProtected)blockEntity;
            SaltData.removeSalt(be.getSaltKey());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeypadTrapdoorBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (IDisguisable.shouldPickBlockDisguise((BlockGetter)level, pos, player)) {
            return this.getDisguisedStack((BlockGetter)level, pos);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        int lightValue = 0;
        if (lightManager != null) {
            lightValue = lightManager.getLightAt(pos);
        }
        return lightValue > 0 ? lightValue : super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShadeBrightness(level, pos);
        }
        return super.getShadeBrightness(state, level, pos);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getLightBlock(level, pos);
        }
        return super.getLightBlock(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).getItem() == this.asItem();
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.is((Block)SCContent.REINFORCED_IRON_TRAPDOOR.get());
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.is((Block)SCContent.KEYPAD_TRAPDOOR.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            return this.convert(level, pos, (Block)SCContent.KEYPAD_TRAPDOOR.get());
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            return this.convert(level, pos, (Block)SCContent.REINFORCED_IRON_TRAPDOOR.get());
        }

        private boolean convert(Level level, BlockPos pos, Block convertedBlock) {
            BlockState state = level.getBlockState(pos);
            Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            Half half = (Half)state.getValue((Property)TrapDoorBlock.HALF);
            boolean waterlogged = (Boolean)state.getValue((Property)TrapDoorBlock.WATERLOGGED);
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof IModuleInventory) {
                IModuleInventory moduleInv = (IModuleInventory)be;
                moduleInv.dropAllModules();
            }
            CompoundTag tag = be.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)convertedBlock.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)TrapDoorBlock.HALF, (Comparable)half)).setValue((Property)TrapDoorBlock.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)TrapDoorBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
            level.getBlockEntity(pos).loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
            return true;
        }
    }
}

