/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.GameProfileLoader;
import customskinloader.loader.ProfileLoader;
import customskinloader.plugin.ICustomSkinLoaderPlugin;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.TextureUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class MojangAPILoader
implements ICustomSkinLoaderPlugin,
ProfileLoader.IProfileLoader {
    private static final Map<String, GameProfile> gameProfileCache = new ConcurrentHashMap<String, GameProfile>();
    private static final String MOJANG_API_ROOT = "https://api{DO_NOT_MODIFY}.mojang.com/";
    private static final String MOJANG_SESSION_ROOT = "https://sessionserver{DO_NOT_MODIFY}.mojang.com/";

    @Override
    public ProfileLoader.IProfileLoader getProfileLoader() {
        return this;
    }

    @Override
    public List<ICustomSkinLoaderPlugin.IDefaultProfile> getDefaultProfiles() {
        return Lists.newArrayList((Object[])new ICustomSkinLoaderPlugin.IDefaultProfile[]{new Mojang(this)});
    }

    @Override
    public UserProfile loadProfile(SkinSiteProfile ssp, GameProfile gameProfile) {
        String username = (String)TextureUtil.AuthlibField.GAME_PROFILE_NAME.get(gameProfile);
        GameProfile newGameProfile = MojangAPILoader.loadGameProfileCached(ssp.apiRoot, username);
        if (newGameProfile == null) {
            CustomSkinLoader.logger.info("Profile not found.(" + username + "'s profile not found.)");
            return null;
        }
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = GameProfileLoader.getTextures(newGameProfile = MojangAPILoader.fillGameProfile(ssp.sessionRoot, newGameProfile));
        if (!map.isEmpty()) {
            return ModelManager0.toUserProfile(map);
        }
        CustomSkinLoader.logger.info("Profile not found.(" + username + " doesn't have skin/cape.)");
        return null;
    }

    public static GameProfile loadGameProfileCached(String apiRoot, String username) {
        return gameProfileCache.computeIfAbsent(apiRoot + " " + username, ignored -> MojangAPILoader.loadGameProfile(apiRoot, username));
    }

    public static GameProfile loadGameProfile(String apiRoot, String username) {
        HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(apiRoot + "profiles/minecraft").setCacheTime(600).setPayload(GameProfileLoader.GSON.toJson(Collections.singletonList(username))));
        if (StringUtils.isEmpty((CharSequence)responce.content)) {
            return null;
        }
        MinecraftProfilePropertiesResponse[] profiles = (MinecraftProfilePropertiesResponse[])GameProfileLoader.GSON.fromJson(responce.content, MinecraftProfilePropertiesResponse[].class);
        if (profiles.length == 0) {
            return null;
        }
        GameProfile gameProfile = MojangAPILoader.createGameProfile(profiles[0]);
        UUID id = (UUID)TextureUtil.AuthlibField.GAME_PROFILE_ID.get(gameProfile);
        if (id == null) {
            return null;
        }
        return new GameProfile(id, (String)TextureUtil.AuthlibField.GAME_PROFILE_NAME.get(gameProfile));
    }

    public static String getMojangUuidByUsername(String username, boolean standard) {
        GameProfile profile = MojangAPILoader.loadGameProfileCached(MojangAPILoader.getMojangApiRoot(), username);
        if (profile == null) {
            return null;
        }
        UUID id = (UUID)TextureUtil.AuthlibField.GAME_PROFILE_ID.get(profile);
        return standard ? id.toString() : TextureUtil.fromUUID(id);
    }

    public static GameProfile fillGameProfile(String sessionRoot, GameProfile profile) {
        HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(sessionRoot + "session/minecraft/profile/" + TextureUtil.fromUUID((UUID)TextureUtil.AuthlibField.GAME_PROFILE_ID.get(profile))).setCacheTime(90));
        if (StringUtils.isEmpty((CharSequence)responce.content)) {
            return profile;
        }
        return MojangAPILoader.createGameProfile((MinecraftProfilePropertiesResponse)GameProfileLoader.GSON.fromJson(responce.content, MinecraftProfilePropertiesResponse.class));
    }

    public static GameProfile createGameProfile(MinecraftProfilePropertiesResponse response) {
        GameProfile profile = new GameProfile((UUID)TextureUtil.AuthlibField.MINECRAFT_PROFILE_PROPERTIES_RESPONSE_ID.get(response), (String)TextureUtil.AuthlibField.MINECRAFT_PROFILE_PROPERTIES_RESPONSE_NAME.get(response));
        PropertyMap map = (PropertyMap)TextureUtil.AuthlibField.MINECRAFT_PROFILE_PROPERTIES_RESPONSE_PROPERTIES.get(response);
        if (map != null) {
            TextureUtil.AuthlibField.PROPERTY_MAP_PROPERTIES.set(TextureUtil.AuthlibField.GAME_PROFILE_PROPERTIES.get(profile), TextureUtil.AuthlibField.PROPERTY_MAP_PROPERTIES.get(map));
        }
        return profile;
    }

    @Override
    public boolean compare(SkinSiteProfile ssp0, SkinSiteProfile ssp1) {
        return !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp0.apiRoot}) || ssp0.apiRoot.equalsIgnoreCase(ssp1.apiRoot) || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp0.sessionRoot}) || ssp0.sessionRoot.equalsIgnoreCase(ssp1.sessionRoot);
    }

    @Override
    public String getName() {
        return "MojangAPI";
    }

    @Override
    public void init(SkinSiteProfile ssp) {
        if (ssp.apiRoot == null) {
            ssp.apiRoot = MojangAPILoader.getMojangApiRoot();
        }
        if (ssp.sessionRoot == null) {
            ssp.sessionRoot = MojangAPILoader.getMojangSessionRoot();
        }
    }

    public static String getMojangApiRoot() {
        return MOJANG_API_ROOT.replace("{DO_NOT_MODIFY}", "");
    }

    public static String getMojangSessionRoot() {
        return MOJANG_SESSION_ROOT.replace("{DO_NOT_MODIFY}", "");
    }

    public static class Mojang
    extends DefaultProfile {
        public Mojang(MojangAPILoader loader) {
            super(loader);
        }

        @Override
        public String getName() {
            return "Mojang";
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public String getAPIRoot() {
            return MojangAPILoader.getMojangApiRoot();
        }

        @Override
        public String getSessionRoot() {
            return MojangAPILoader.getMojangSessionRoot();
        }
    }

    public static abstract class DefaultProfile
    implements ICustomSkinLoaderPlugin.IDefaultProfile {
        protected final MojangAPILoader loader;

        public DefaultProfile(MojangAPILoader loader) {
            this.loader = loader;
        }

        @Override
        public void updateSkinSiteProfile(SkinSiteProfile ssp) {
            ssp.type = this.loader.getName();
            ssp.apiRoot = this.getAPIRoot();
            ssp.sessionRoot = this.getSessionRoot();
        }

        public abstract String getAPIRoot();

        public abstract String getSessionRoot();
    }
}

