/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.config;

import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.plugin.ICustomSkinLoaderPlugin;
import customskinloader.plugin.PluginLoader;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.Version;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class Config {
    public String version = "14.26.1";
    public int buildNumber = CustomSkinLoader.CustomSkinLoader_BUILD_NUMBER;
    public List<SkinSiteProfile> loadlist;
    public boolean enableDynamicSkull = true;
    public boolean enableTransparentSkin = true;
    public boolean forceLoadAllTextures = true;
    public boolean enableCape = true;
    public int threadPoolSize = 8;
    public boolean enableLogStdOut = false;
    public int cacheExpiry = 30;
    public boolean forceUpdateSkull = false;
    public boolean enableLocalProfileCache = false;
    public boolean enableCacheAutoClean = false;
    public boolean forceDisableCache = false;

    public Config() {
        this(new ArrayList<SkinSiteProfile>());
    }

    public Config(List<SkinSiteProfile> loadlist) {
        this.loadlist = loadlist;
    }

    public static Config loadConfig0() {
        Config config = Config.loadConfig();
        if (config.loadlist == null) {
            config.loadlist = new ArrayList<SkinSiteProfile>();
        } else {
            for (int i = 0; i < config.loadlist.size(); ++i) {
                if (config.loadlist.get(i) != null) continue;
                config.loadlist.remove(i--);
            }
        }
        config.loadExtraList();
        config.updateLoadlist();
        config.initLocalFolder();
        config.threadPoolSize = Math.max(config.threadPoolSize, 1);
        if (config.enableCacheAutoClean && !config.enableLocalProfileCache) {
            try {
                FileUtils.deleteDirectory((File)HttpRequestUtil.CACHE_DIR);
                FileUtils.deleteDirectory((File)HttpTextureUtil.getCacheDir());
                CustomSkinLoader.logger.info("Successfully cleaned cache.");
            }
            catch (Exception e) {
                CustomSkinLoader.logger.warning("Exception occurs while cleaning cache: " + e);
            }
        }
        Version configVersion = Version.of(config.version);
        if (CustomSkinLoader.CustomSkinLoader_BUILD_NUMBER == 0 || configVersion.compareTo("14.26.1") < 0 || config.buildNumber < CustomSkinLoader.CustomSkinLoader_BUILD_NUMBER) {
            CustomSkinLoader.logger.info("Config File is out of date: " + config.version + ", build number: " + config.buildNumber);
            config.version = "14.26.1";
            config.buildNumber = CustomSkinLoader.CustomSkinLoader_BUILD_NUMBER;
        }
        Config.writeConfig(config, true);
        for (Field field : config.getClass().getDeclaredFields()) {
            try {
                Object value = field.get(config);
                CustomSkinLoader.logger.info(field.getName() + " : " + value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return config;
    }

    private static Config loadConfig() {
        CustomSkinLoader.logger.info("Config File: " + CustomSkinLoader.CONFIG_FILE.getAbsolutePath());
        if (!CustomSkinLoader.CONFIG_FILE.exists()) {
            CustomSkinLoader.logger.info("Config file not found, use default instead.");
            return Config.initConfig();
        }
        try {
            CustomSkinLoader.logger.info("Try to load config.");
            String json = FileUtils.readFileToString((File)CustomSkinLoader.CONFIG_FILE, (String)"UTF-8");
            Config config = (Config)Objects.requireNonNull(CustomSkinLoader.GSON.fromJson(json, Config.class));
            CustomSkinLoader.logger.info("Successfully load config.");
            return config;
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to load config, use default instead.(" + e + ")");
            Config.createBrokenFile(CustomSkinLoader.CONFIG_FILE);
            return Config.initConfig();
        }
    }

    private void loadExtraList() {
        File listAddition = new File(CustomSkinLoader.DATA_DIR, "ExtraList");
        if (!listAddition.isDirectory()) {
            listAddition.mkdirs();
            return;
        }
        ArrayList<SkinSiteProfile> adds = new ArrayList<SkinSiteProfile>();
        File[] files = listAddition.listFiles();
        for (File file : files != null ? files : new File[]{}) {
            if (!file.getName().toLowerCase().endsWith(".json") && !file.getName().toLowerCase().endsWith(".txt")) continue;
            try {
                CustomSkinLoader.logger.info("Try to load Extra List.(" + file.getName() + ")");
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                SkinSiteProfile ssp = (SkinSiteProfile)CustomSkinLoader.GSON.fromJson(json, SkinSiteProfile.class);
                CustomSkinLoader.logger.info("Successfully load Extra List.");
                if (ssp.type != null) {
                    ProfileLoader.IProfileLoader loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase());
                    if (loader == null) {
                        CustomSkinLoader.logger.info("Extra List will be ignored: Type '" + ssp.type + "' is not defined.");
                        continue;
                    }
                    boolean duplicate = false;
                    for (SkinSiteProfile ssp0 : this.loadlist) {
                        if (!ssp0.type.equalsIgnoreCase(ssp.type) || !loader.compare(ssp0, ssp)) continue;
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        adds.add(ssp);
                        CustomSkinLoader.logger.info("Successfully apply Extra List.(" + ssp.name + ")");
                    } else {
                        CustomSkinLoader.logger.info("Extra List will be ignored: Duplicate.(" + ssp.name + ")");
                    }
                    file.delete();
                    continue;
                }
                CustomSkinLoader.logger.info("Extra List is invalid: Type is not defined.(" + file.getName() + ")");
                Config.createBrokenFile(file);
            }
            catch (Exception e) {
                CustomSkinLoader.logger.info("Failed to load Extra List.(" + e + ")");
                Config.createBrokenFile(file);
            }
        }
        if (adds.size() != 0) {
            adds.addAll(this.loadlist);
            this.loadlist = adds;
        }
    }

    private void updateLoadlist() {
        PluginLoader.PLUGINS.stream().map(ICustomSkinLoaderPlugin::getDefaultProfiles).filter(Objects::nonNull).flatMap(Collection::stream).forEach(profile -> this.loadlist.stream().filter(ssp -> profile.getName().equals(ssp.name)).forEach(profile::updateSkinSiteProfile));
    }

    private void initLocalFolder() {
        for (SkinSiteProfile ssp : this.loadlist) {
            ProfileLoader.IProfileLoader loader;
            if (ssp.type == null || (loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase())) == null) continue;
            loader.init(ssp);
        }
    }

    private static void createBrokenFile(File file) {
        try {
            File brokenFile = new File(file.getParentFile(), file.getName() + ".broken");
            if (brokenFile.exists()) {
                brokenFile.delete();
            }
            file.renameTo(brokenFile);
        }
        catch (Exception e) {
            CustomSkinLoader.logger.warning("Failed to create broken file. (" + file.getName() + ")");
            CustomSkinLoader.logger.warning(e);
        }
    }

    private static Config initConfig() {
        ArrayList<ICustomSkinLoaderPlugin.IDefaultProfile> profiles = new ArrayList<ICustomSkinLoaderPlugin.IDefaultProfile>();
        for (ICustomSkinLoaderPlugin iCustomSkinLoaderPlugin : PluginLoader.PLUGINS) {
            List<ICustomSkinLoaderPlugin.IDefaultProfile> defaultProfiles = iCustomSkinLoaderPlugin.getDefaultProfiles();
            if (defaultProfiles == null) continue;
            profiles.addAll(defaultProfiles);
        }
        profiles.sort(Comparator.comparingInt(ICustomSkinLoaderPlugin.IDefaultProfile::getPriority));
        ArrayList<SkinSiteProfile> loadlist = new ArrayList<SkinSiteProfile>();
        for (ICustomSkinLoaderPlugin.IDefaultProfile profile : profiles) {
            SkinSiteProfile ssp = new SkinSiteProfile();
            ssp.name = profile.getName();
            profile.updateSkinSiteProfile(ssp);
            loadlist.add(ssp);
        }
        Config config = new Config(loadlist);
        Config.writeConfig(config, false);
        return config;
    }

    private static void writeConfig(Config config, boolean update) {
        String json = CustomSkinLoader.GSON.toJson((Object)config);
        if (CustomSkinLoader.CONFIG_FILE.exists()) {
            CustomSkinLoader.CONFIG_FILE.delete();
        }
        try {
            CustomSkinLoader.CONFIG_FILE.createNewFile();
            FileUtils.write((File)CustomSkinLoader.CONFIG_FILE, (CharSequence)json, (String)"UTF-8");
            CustomSkinLoader.logger.info("Successfully " + (update ? "update" : "create") + " config.");
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to " + (update ? "update" : "create") + " config.(" + e + ")");
        }
    }
}

