/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeUtils {
    public static Optional<? extends Registry<Biome>> getBiomeRegistry(Level level) {
        return level.registryAccess().registry(Registries.BIOME);
    }

    public static Optional<ResourceLocation> getKeyForBiome(Level level, Biome biome) {
        return BiomeUtils.getBiomeRegistry(level).isPresent() ? Optional.of(BiomeUtils.getBiomeRegistry(level).get().getKey((Object)biome)) : Optional.empty();
    }

    public static Optional<Biome> getBiomeForKey(Level level, ResourceLocation key) {
        return BiomeUtils.getBiomeRegistry(level).isPresent() ? BiomeUtils.getBiomeRegistry(level).get().getOptional(key) : Optional.empty();
    }

    public static List<ResourceLocation> getAllowedBiomeKeys(Level level) {
        ArrayList<ResourceLocation> biomeKeys = new ArrayList<ResourceLocation>();
        if (BiomeUtils.getBiomeRegistry(level).isPresent()) {
            for (Map.Entry entry : BiomeUtils.getBiomeRegistry(level).get().entrySet()) {
                Biome biome = (Biome)entry.getValue();
                if (biome == null) continue;
                Optional<ResourceLocation> optionalBiomeKey = BiomeUtils.getKeyForBiome(level, biome);
                if (biome == null || !optionalBiomeKey.isPresent() || BiomeUtils.biomeKeyIsBlacklisted(level, optionalBiomeKey.get()) || BiomeUtils.biomeKeyIsHidden(level, optionalBiomeKey.get())) continue;
                biomeKeys.add(optionalBiomeKey.get());
            }
        }
        return biomeKeys;
    }

    public static List<ResourceLocation> getGeneratingDimensionKeys(ServerLevel serverLevel, Biome biome) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        Registry<Biome> biomeRegistry = BiomeUtils.getBiomeRegistry((Level)serverLevel).get();
        for (ServerLevel level : serverLevel.getServer().getAllLevels()) {
            Holder biomeHolder;
            Set biomeSet = level.getChunkSource().getGenerator().getBiomeSource().possibleBiomes();
            if (!biomeSet.contains(biomeHolder = (Holder)biomeRegistry.getHolder((ResourceKey)biomeRegistry.getResourceKey((Object)biome).get()).get())) continue;
            dimensions.add(level.dimension().location());
        }
        return dimensions;
    }

    public static ListMultimap<ResourceLocation, ResourceLocation> getGeneratingDimensionsForAllowedBiomes(ServerLevel serverLevel) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (ResourceLocation biomeKey : BiomeUtils.getAllowedBiomeKeys((Level)serverLevel)) {
            Optional<Biome> optionalBiome = BiomeUtils.getBiomeForKey((Level)serverLevel, biomeKey);
            if (!optionalBiome.isPresent()) continue;
            dimensionsForAllowedStructures.putAll((Object)biomeKey, BiomeUtils.getGeneratingDimensionKeys(serverLevel, optionalBiome.get()));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getBiomeSize(Level world) {
        return 4;
    }

    public static int getDistanceToBiome(Player player, int biomeX, int biomeZ) {
        return BiomeUtils.getDistanceToBiome(player.blockPosition(), biomeX, biomeZ);
    }

    public static int getDistanceToBiome(BlockPos startPos, int biomeX, int biomeZ) {
        return (int)Mth.sqrt((float)((float)startPos.distSqr((Vec3i)new BlockPos(biomeX, startPos.getY(), biomeZ))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeTags(Level level, Biome biome) {
        Registry<Biome> biomeRegistry;
        List<String> tagPathsToIgnore = List.of("is_overworld");
        TreeSet<String> biomeCategories = new TreeSet<String>();
        if (BiomeUtils.getBiomeRegistry(level).isPresent() && (biomeRegistry = BiomeUtils.getBiomeRegistry(level).get()).getResourceKey((Object)biome).isPresent() && biomeRegistry.getHolder((ResourceKey)biomeRegistry.getResourceKey((Object)biome).get()).isPresent()) {
            Holder biomeHolder = (Holder)biomeRegistry.getHolder((ResourceKey)biomeRegistry.getResourceKey((Object)biome).get()).get();
            List categoryTags = biomeHolder.tags().filter(tag -> tag.location().getPath().startsWith("is_")).collect(Collectors.toList());
            for (TagKey tag2 : categoryTags) {
                String translatedCategoryKey;
                String translatedBiomeKey;
                String biomeKey;
                if (tagPathsToIgnore.contains(tag2.location().getPath())) continue;
                String fixedPath = tag2.location().getPath().replaceFirst("is_", "");
                if (fixedPath.contains("/")) {
                    fixedPath = fixedPath.substring(0, fixedPath.indexOf("/"));
                }
                if (!(biomeKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)tag2.location().getNamespace(), (String)fixedPath))).equals(translatedBiomeKey = I18n.get((String)biomeKey, (Object[])new Object[0]))) {
                    return translatedBiomeKey;
                }
                String categoryKey = Util.makeDescriptionId((String)"category", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)tag2.location().getNamespace(), (String)fixedPath));
                if (!categoryKey.equals(translatedCategoryKey = I18n.get((String)categoryKey, (Object[])new Object[0]))) {
                    return translatedCategoryKey;
                }
                biomeCategories.add(WordUtils.capitalize((String)fixedPath.replace('_', ' ')));
            }
        }
        if (biomeCategories.isEmpty()) {
            biomeCategories.add(I18n.get((String)"string.naturescompass.none", (Object[])new Object[0]));
        }
        return String.join((CharSequence)", ", biomeCategories);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(Level level, ResourceLocation biome) {
        if (BiomeUtils.getBiomeForKey(level, biome).isPresent()) {
            return BiomeUtils.getBiomeNameForDisplay(level, BiomeUtils.getBiomeForKey(level, biome).get());
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(Level level, Biome biome) {
        if (biome != null) {
            if (((Boolean)ConfigHandler.CLIENT.fixBiomeNames.get()).booleanValue()) {
                String original = BiomeUtils.getBiomeName(level, biome);
                Object fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = (String)fixed + " ";
                    }
                    fixed = (String)fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            if (BiomeUtils.getKeyForBiome(level, biome) != null) {
                return I18n.get((String)BiomeUtils.getKeyForBiome(level, biome).toString(), (Object[])new Object[0]);
            }
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(Level level, Biome biome) {
        return BiomeUtils.getKeyForBiome(level, biome).isPresent() ? I18n.get((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)BiomeUtils.getKeyForBiome(level, biome).get()), (Object[])new Object[0]) : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(Level level, ResourceLocation key) {
        if (BiomeUtils.getBiomeForKey(level, key).isPresent()) {
            return BiomeUtils.getBiomeName(level, BiomeUtils.getBiomeForKey(level, key).get());
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeSource(Level level, Biome biome) {
        if (BiomeUtils.getKeyForBiome(level, biome).isEmpty()) {
            return "";
        }
        String modid = BiomeUtils.getKeyForBiome(level, biome).get().getNamespace();
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.get((String)Util.makeDescriptionId((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.makeDescriptionId((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String dimensionKeysToString(List<ResourceLocation> dimensions) {
        HashSet dimensionNames = new HashSet();
        dimensions.forEach(key -> dimensionNames.add(BiomeUtils.getDimensionName(key)));
        return String.join((CharSequence)", ", dimensionNames);
    }

    public static boolean biomeKeyIsBlacklisted(Level level, ResourceLocation biomeKey) {
        List biomeBlacklist = (List)ConfigHandler.GENERAL.biomeBlacklist.get();
        for (String key : biomeBlacklist) {
            if (!biomeKey.toString().matches(BiomeUtils.convertToRegex(key))) continue;
            return true;
        }
        return false;
    }

    public static boolean biomeKeyIsHidden(Level level, ResourceLocation biomeKey) {
        Biome biome;
        Registry<Biome> biomeRegistry;
        if (BiomeUtils.getBiomeRegistry(level).isPresent() && BiomeUtils.getBiomeForKey(level, biomeKey).isPresent() && (biomeRegistry = BiomeUtils.getBiomeRegistry(level).get()).getResourceKey((Object)(biome = BiomeUtils.getBiomeForKey(level, biomeKey).get())).isPresent() && biomeRegistry.getHolder((ResourceKey)biomeRegistry.getResourceKey((Object)biome).get()).isPresent()) {
            Holder biomeHolder = (Holder)biomeRegistry.getHolder((ResourceKey)biomeRegistry.getResourceKey((Object)biome).get()).get();
            return biomeHolder.tags().anyMatch(tag -> tag.location().getPath().equals("c:hidden_from_locator_selection"));
        }
        return false;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

