/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.client;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.client.NaturesCompassOverlay;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.CompassState;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="naturescompass", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NaturesCompassClient {
    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)NaturesCompass.naturesCompass, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"naturescompass", (String)"angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float unclampedCall(ItemStack stack, ClientLevel world, LivingEntity entityLiving, int seed) {
                LivingEntity entity;
                if (entityLiving == null && !stack.isFramed()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.getFrame();
                if (world == null && entity.level() instanceof ClientLevel) {
                    world = (ClientLevel)entity.level();
                }
                double rotation = entityExists ? (double)entity.getYRot() : this.getFrameRotation((ItemFrame)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return Mth.positiveModulo((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientLevel world, double amount) {
                if (world.getGameTime() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.getGameTime();
                    double d0 = amount - this.rotation;
                    d0 = Mth.positiveModulo((double)(d0 + Math.PI), (double)(Math.PI * 2)) - Math.PI;
                    d0 = Mth.clamp((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.getDirection();
                int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
                return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + itemFrame.getRotation() * 45 + i));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(ClientLevel world, Entity entity, ItemStack stack) {
                if (stack.getItem() == NaturesCompass.naturesCompass) {
                    NaturesCompassItem compassItem = (NaturesCompassItem)stack.getItem();
                    BlockPos pos = compassItem.getState(stack) == CompassState.FOUND ? new BlockPos(compassItem.getFoundBiomeX(stack), 0, compassItem.getFoundBiomeZ(stack)) : world.getSharedSpawnPos();
                    return Math.atan2((double)pos.getZ() - entity.position().z(), (double)pos.getX() - entity.position().x());
                }
                return 0.0;
            }
        }));
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.BOSS_OVERLAY, ResourceLocation.fromNamespaceAndPath((String)"naturescompass", (String)"natures_compass"), (LayeredDraw.Layer)new NaturesCompassOverlay());
    }
}

