/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.util;

import com.iamkaf.amber.api.platform.v1.Platform;
import com.iamkaf.amber.util.Env;
import java.util.Optional;
import java.util.function.Supplier;
import net.neoforged.api.distmarker.Dist;

public final class EnvExecutor {
    private EnvExecutor() {
    }

    public static void runInEnv(Dist type, Supplier<Runnable> runnableSupplier) {
        EnvExecutor.runInEnv(Env.fromPlatform(type), runnableSupplier);
    }

    public static void runInEnv(Env type, Supplier<Runnable> runnableSupplier) {
        if (Platform.getEnvironment() == type) {
            runnableSupplier.get().run();
        }
    }

    public static <T> Optional<T> getInEnv(Dist type, Supplier<Supplier<T>> runnableSupplier) {
        return EnvExecutor.getInEnv(Env.fromPlatform(type), runnableSupplier);
    }

    public static <T> Optional<T> getInEnv(Env type, Supplier<Supplier<T>> runnableSupplier) {
        if (Platform.getEnvironment() == type) {
            return Optional.ofNullable(runnableSupplier.get().get());
        }
        return Optional.empty();
    }

    public static <T> T getEnvSpecific(Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            return client.get().get();
        }
        return server.get().get();
    }
}

