/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.item;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ArmorTierHelper {
    public static Map<ArmorItem.Type, Integer> defense(int boots, int leggings, int chestplate, int helmet, int body) {
        return (Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, boots);
            map.put(ArmorItem.Type.LEGGINGS, leggings);
            map.put(ArmorItem.Type.CHESTPLATE, chestplate);
            map.put(ArmorItem.Type.HELMET, helmet);
            map.put(ArmorItem.Type.BODY, body);
        });
    }

    public static List<ArmorMaterial.Layer> genericLayers(String modId, String name) {
        ArrayList<ArmorMaterial.Layer> layers = new ArrayList<ArmorMaterial.Layer>();
        layers.add(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)modId, (String)name)));
        return layers;
    }

    public static List<ArmorMaterial.Layer> genericLayers(String modId, String name, boolean dyeable) {
        ArrayList<ArmorMaterial.Layer> layers = new ArrayList<ArmorMaterial.Layer>();
        layers.add(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)modId, (String)name)));
        if (dyeable) {
            layers.add(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)modId, (String)name), "_overlay", true));
        }
        return layers;
    }

    public static Supplier<Ingredient> repair(Supplier<Item> item) {
        return () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()});
    }

    public static enum VanillaEnchantability {
        TURTLE_SHELL(9),
        LEATHER(15),
        GOLD(25),
        CHAINMAIL(12),
        IRON(9),
        DIAMOND(10),
        NETHERITE(15);

        public final int enchantability;

        private VanillaEnchantability(int enchantability) {
            this.enchantability = enchantability;
        }
    }

    public static enum VanillaKnockbackResistance {
        TURTLE_SHELL(0.0f),
        LEATHER(0.0f),
        GOLD(0.0f),
        CHAINMAIL(0.0f),
        IRON(0.0f),
        DIAMOND(0.02f),
        NETHERITE(0.1f);

        public final float knockbackResistance;

        private VanillaKnockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
        }
    }

    public static enum VanillaToughness {
        TURTLE_SHELL(0, 0, 0, 0, 0),
        LEATHER(0, 0, 0, 0, 0),
        GOLD(0, 0, 0, 0, 0),
        CHAINMAIL(0, 0, 0, 0, 0),
        IRON(0, 0, 0, 0, 0),
        DIAMOND(8, 2, 2, 2, 2),
        NETHERITE(13, 3, 3, 3, 3);

        public final int fullSet;
        public final int helmet;
        public final int chestplate;
        public final int leggings;
        public final int boots;

        private VanillaToughness(int fullSet, int helmet, int chestplate, int leggings, int boots) {
            this.fullSet = fullSet;
            this.helmet = helmet;
            this.chestplate = chestplate;
            this.leggings = leggings;
            this.boots = boots;
        }
    }
}

