/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.inventory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemHelper {
    public static void repairBy(ItemStack item, float percent) {
        item.setDamageValue(Math.round((float)item.getDamageValue() - (float)item.getMaxDamage() * percent));
    }

    public static String getIngredientDisplayName(Ingredient ingredient) {
        ItemStack[] items = ingredient.getItems();
        if (items.length == 1) {
            return items[0].getDisplayName().getString();
        }
        String itemNames = Arrays.stream(items).limit(3L).map(item -> item.getDisplayName().getString()).collect(Collectors.joining(", "));
        return "One of " + itemNames + ", etc...";
    }

    public static void addModifier(ItemStack stack, Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slotGroup) {
        DataComponentType attributeModifiersComponent = DataComponents.ATTRIBUTE_MODIFIERS;
        ItemAttributeModifiers extraModifiers = (ItemAttributeModifiers)stack.get(attributeModifiersComponent);
        assert (extraModifiers != null);
        ItemAttributeModifiers.Builder attributeBuilder = ItemAttributeModifiers.builder();
        ItemAttributeModifiers defaultModifiers = stack.getItem().getDefaultAttributeModifiers();
        HashSet<ResourceLocation> added = new HashSet<ResourceLocation>();
        for (ItemAttributeModifiers.Entry mod : defaultModifiers.modifiers()) {
            if (added.contains(mod.modifier().id())) continue;
            attributeBuilder.add(mod.attribute(), mod.modifier(), mod.slot());
            added.add(mod.modifier().id());
        }
        for (ItemAttributeModifiers.Entry mod : extraModifiers.modifiers()) {
            if (mod.modifier().id().equals((Object)modifier.id()) || added.contains(mod.modifier().id())) continue;
            attributeBuilder.add(mod.attribute(), mod.modifier(), mod.slot());
            added.add(mod.modifier().id());
        }
        attributeBuilder.add(attribute, modifier, slotGroup);
        stack.set(attributeModifiersComponent, (Object)attributeBuilder.build());
    }

    public static boolean hasModifier(ItemStack stack, ResourceLocation id) {
        ItemAttributeModifiers list = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
        assert (list != null);
        return list.modifiers().stream().anyMatch(m -> m.modifier().id().equals((Object)id));
    }
}

