/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.inventory;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class InventoryHelper {
    public static boolean consumeIfAvailable(Inventory inventory, ItemLike item) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.getItem() != item.asItem() || stack.getCount() <= 0) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public static boolean consumeIfAvailable(Inventory inventory, ItemLike item, int amount) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.getItem() != item.asItem() || stack.getCount() < amount) continue;
            stack.shrink(amount);
            return true;
        }
        return false;
    }

    public static boolean consumeIfAvailable(Inventory inventory, Ingredient ingredient, int amount) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!ingredient.test(stack) || stack.getCount() < amount) continue;
            stack.shrink(amount);
            return true;
        }
        return false;
    }

    public static boolean has(Inventory inventory, ItemLike item) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.getItem() != item.asItem() || stack.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean has(Inventory inventory, Ingredient ingredient) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean has(Inventory inventory, Ingredient ingredient, int amount) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!ingredient.test(stack) || stack.getCount() < amount) continue;
            return true;
        }
        return false;
    }
}

