/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.config.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.iamkaf.amber.Amber;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class JsonFileReader<T> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Type type;
    private final String fileName;
    private final Path directoryPath;
    private final Map<String, T> defaultValues;

    public JsonFileReader(String fileName, Path directoryPath, Type type, Map<String, T> defaultValues) {
        this.fileName = fileName;
        this.directoryPath = directoryPath;
        this.type = type;
        this.defaultValues = defaultValues;
    }

    public Map<String, T> read() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        File directory = new File(String.valueOf(this.directoryPath));
        File file = new File(directory, this.fileName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!file.exists()) {
            try (FileWriter writer = new FileWriter(file);){
                writer.write(this.gson.toJson(this.defaultValues));
            }
            catch (Exception e) {
                Amber.LOGGER.error(e.getLocalizedMessage());
                return data;
            }
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                data.put((String)entry.getKey(), this.gson.fromJson((JsonElement)entry.getValue(), this.type));
            }
        }
        catch (Exception e) {
            Amber.LOGGER.error(e.getLocalizedMessage());
        }
        return data;
    }

    public <K, V> Map<K, V> transform(Map<String, T> data, Function<String, K> keyTransformer, Function<T, V> valueTransformer) {
        HashMap<K, V> transformedData = new HashMap<K, V>();
        for (Map.Entry<String, T> entry : data.entrySet()) {
            transformedData.put(keyTransformer.apply(entry.getKey()), valueTransformer.apply(entry.getValue()));
        }
        return transformedData;
    }

    public <K, V> Map<K, V> readTransformed(Function<String, K> keyTransformer, Function<T, V> valueTransformer) {
        return this.transform(this.read(), keyTransformer, valueTransformer);
    }

    public void createBackup() {
        File directory = new File(String.valueOf(this.directoryPath));
        File file = new File(directory, this.fileName);
        @Nullable File mostRecentBackup = null;
        File backup = null;
        if (!directory.exists()) {
            directory.mkdirs();
        }
        int count = 0;
        do {
            mostRecentBackup = backup;
        } while ((backup = new File(directory, this.fileName + ".bak" + ++count)).exists());
        if (this.areFilesEqual(file, mostRecentBackup)) {
            return;
        }
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);
                 FileWriter writer = new FileWriter(backup);){
                int bytesRead;
                char[] buffer = new char[1024];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                Amber.LOGGER.error(e.getLocalizedMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean areFilesEqual(File fileA, File fileB) {
        if (!fileA.exists()) return false;
        if (fileB == null) return false;
        if (!fileB.exists()) {
            return false;
        }
        if (fileA.length() != fileB.length()) {
            return false;
        }
        try (FileReader readerA = new FileReader(fileA);
             FileReader readerB = new FileReader(fileB);){
            int charB;
            int charA;
            do {
                if ((charA = readerA.read()) == -1) return true;
                charB = readerB.read();
                if (charB == -1) return true;
            } while (charA == charB);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Amber.LOGGER.error(e.getLocalizedMessage());
            return false;
        }
    }
}

