/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.MinMaxBounds;
import top.theillusivec4.curios.api.SlotContext;

public record SlotPredicate(List<String> slots, MinMaxBounds.Ints index) {
    public static final Codec<SlotPredicate> CODEC = RecordCodecBuilder.create(slotPredicateInstance -> slotPredicateInstance.group((App)Codec.STRING.listOf().optionalFieldOf("slots", List.of()).forGetter(SlotPredicate::slots), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("index", (Object)MinMaxBounds.Ints.ANY).forGetter(SlotPredicate::index)).apply((Applicative)slotPredicateInstance, SlotPredicate::new));

    public boolean matches(SlotContext slotContext) {
        if (!this.slots.contains(slotContext.identifier())) {
            return false;
        }
        return this.index.matches(slotContext.index());
    }

    public static class Builder {
        private Set<String> identifiers = new HashSet<String>();
        private MinMaxBounds.Ints indices = MinMaxBounds.Ints.ANY;

        private Builder() {
        }

        public static Builder slot() {
            return new Builder();
        }

        public Builder of(String ... identifiers) {
            this.identifiers = (Set)Stream.of(identifiers).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public Builder withIndex(MinMaxBounds.Ints index) {
            this.indices = index;
            return this;
        }

        public SlotPredicate build() {
            return new SlotPredicate(this.identifiers.stream().toList(), this.indices);
        }
    }
}

