/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import mekanism.api.IContentsListener;
import mekanism.api.heat.HeatAPI;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.FuelInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityFuelwoodHeater
extends TileEntityMekanism {
    public static final double HEAT_CAPACITY = 100.0;
    public static final double INVERSE_CONDUCTION_COEFFICIENT = 5.0;
    public static final double INVERSE_INSULATION_COEFFICIENT = 10.0;
    public int burnTime;
    public int maxBurnTime;
    private double lastEnvironmentLoss;
    private double lastTransferLoss;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel slot")
    FuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="heater")
    BasicHeatCapacitor heatCapacitor;

    public TileEntityFuelwoodHeater(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.FUELWOOD_HEATER, pos, state);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        this.fuelSlot = FuelInventorySlot.forFuel(stack -> stack.getBurnTime(null), listener, 15, 29);
        builder.addSlot(this.fuelSlot);
        return builder.build();
    }

    @Override
    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this.facingSupplier);
        this.heatCapacitor = BasicHeatCapacitor.create(100.0, 5.0, 10.0, ambientTemperature, listener);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.burnTime == 0) {
            this.maxBurnTime = this.burnTime = this.fuelSlot.burn();
        }
        if (this.burnTime > 0) {
            int ticks = Math.min(this.burnTime, MekanismConfig.general.fuelwoodTickMultiplier.get());
            this.burnTime -= ticks;
            this.heatCapacitor.handleHeat(MekanismConfig.general.heatPerFuelTick.get() * (double)ticks);
            this.setActive(true);
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastEnvironmentLoss = loss.environmentTransfer();
        this.lastTransferLoss = loss.adjacentTransfer();
        return sendUpdatePacket;
    }

    @ComputerMethod(nameOverride="getTransferLoss")
    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.burnTime = nbt.getInt("burn_time");
        this.maxBurnTime = nbt.getInt("max_burn_time");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putInt("burn_time", this.burnTime);
        nbtTags.putInt("max_burn_time", this.maxBurnTime);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.burnTime, value -> {
            this.burnTime = value;
        }));
        container.track(SyncableInt.create(() -> this.maxBurnTime, value -> {
            this.maxBurnTime = value;
        }));
        container.track(SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

