/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.prefab.BlockBase;
import mekanism.common.block.transmitter.BlockTransmitter;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.tier.TransporterTier;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class MekanismCreativeTabs {
    public static final CreativeTabDeferredRegister CREATIVE_TABS = new CreativeTabDeferredRegister("mekanism", MekanismCreativeTabs::addToExistingTabs);
    public static final MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> MEKANISM = CREATIVE_TABS.registerMain(MekanismLang.MEKANISM, (Holder<Item>)MekanismBlocks.METALLURGIC_INFUSER.getItemHolder(), builder -> builder.withSearchBar().displayItems((displayParameters, output) -> {
        CreativeTabDeferredRegister.addToDisplay(MekanismItems.ITEMS, output);
        CreativeTabDeferredRegister.addToDisplay(MekanismBlocks.BLOCKS, output);
        CreativeTabDeferredRegister.addToDisplay(MekanismFluids.FLUIDS, output);
        MekanismCreativeTabs.addFilledTanks(displayParameters, output, true);
    }));

    private static void addFilledTanks(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, boolean chemical) {
        if (MekanismConfig.general.isLoaded()) {
            if (MekanismConfig.general.prefilledFluidTanks.get()) {
                parameters.holders().lookupOrThrow(Registries.FLUID).filterElements(fluid -> fluid != Fluids.EMPTY && fluid.isSource(fluid.defaultFluidState())).listElements().filter(holder -> !holder.is(Tags.Fluids.HIDDEN_FROM_RECIPE_VIEWERS)).forEach(holder -> output.accept(FluidUtils.getFilledVariant(MekanismBlocks.CREATIVE_FLUID_TANK.getItemHolder(), (Holder<Fluid>)holder)));
            }
            if (chemical && MekanismConfig.general.prefilledChemicalTanks.get()) {
                parameters.holders().lookupOrThrow(MekanismAPI.CHEMICAL_REGISTRY_NAME).listElements().filter(holder -> !holder.is(MekanismAPITags.Chemicals.HIDDEN_FROM_RECIPE_VIEWERS) && !holder.is(MekanismAPI.EMPTY_CHEMICAL_KEY)).forEach(holder -> output.accept(ChemicalUtil.getFilledVariant(MekanismBlocks.CREATIVE_CHEMICAL_TANK.getItemHolder(), (Holder<Chemical>)holder)));
            }
        }
    }

    private static void addToExistingTabs(BuildCreativeModeTabContentsEvent event) {
        block7: {
            ResourceKey tabKey;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block6: {
                                        tabKey = event.getTabKey();
                                        if (tabKey != CreativeModeTabs.BUILDING_BLOCKS) break block6;
                                        CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.SALT_BLOCK, MekanismBlocks.BRONZE_BLOCK, MekanismBlocks.STEEL_BLOCK, MekanismBlocks.CHARCOAL_BLOCK, MekanismBlocks.REFINED_OBSIDIAN_BLOCK, MekanismBlocks.REFINED_GLOWSTONE_BLOCK);
                                        for (PrimaryResource resource : EnumUtils.PRIMARY_RESOURCES) {
                                            if (resource.getResourceBlockInfo() == null) continue;
                                            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.PROCESSED_RESOURCE_BLOCKS.get(resource));
                                        }
                                        break block7;
                                    }
                                    if (tabKey != CreativeModeTabs.NATURAL_BLOCKS) break block8;
                                    CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.SALT_BLOCK);
                                    for (OreBlockType oreBlockType : MekanismBlocks.ORES.values()) {
                                        CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, oreBlockType.stone(), oreBlockType.deepslate());
                                    }
                                    break block7;
                                }
                                if (tabKey != CreativeModeTabs.FUNCTIONAL_BLOCKS) break block9;
                                for (Holder holder : MekanismBlocks.BLOCKS.getSecondaryEntries()) {
                                    BlockBase base;
                                    BlockItem blockItem;
                                    Block block;
                                    Object resource = holder.value();
                                    if (!(resource instanceof BlockItem) || !((block = (blockItem = (BlockItem)resource).getBlock()) instanceof BlockTransmitter) && (!(block instanceof BlockBase) || !((base = (BlockBase)block).getType() instanceof Machine))) continue;
                                    CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, holder);
                                }
                                CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.SECURITY_DESK, MekanismBlocks.RADIOACTIVE_WASTE_BARREL, MekanismBlocks.PERSONAL_CHEST, MekanismBlocks.PERSONAL_BARREL, MekanismBlocks.CHARGEPAD, MekanismBlocks.LASER, MekanismBlocks.LASER_AMPLIFIER, MekanismBlocks.LASER_TRACTOR_BEAM, MekanismBlocks.QUANTUM_ENTANGLOPORTER, MekanismBlocks.OREDICTIONIFICATOR, MekanismBlocks.FUELWOOD_HEATER, MekanismBlocks.MODIFICATION_STATION, MekanismBlocks.QIO_DRIVE_ARRAY, MekanismBlocks.QIO_DASHBOARD, MekanismBlocks.QIO_EXPORTER, MekanismBlocks.QIO_IMPORTER, MekanismBlocks.QIO_REDSTONE_ADAPTER);
                                break block7;
                            }
                            if (tabKey != CreativeModeTabs.REDSTONE_BLOCKS) break block10;
                            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.INDUSTRIAL_ALARM);
                            for (Holder holder : MekanismBlocks.BLOCKS.getSecondaryEntries()) {
                                AttributeTier attribute;
                                Object block = holder.value();
                                if (!(block instanceof BlockItem)) continue;
                                BlockItem blockItem = (BlockItem)block;
                                if (Attribute.has((Block)(block = blockItem.getBlock()), Attributes.AttributeComparator.class)) {
                                    CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, holder);
                                    continue;
                                }
                                if (!(block instanceof BlockTransmitter) || (attribute = Attribute.get((Block)block, AttributeTier.class)) == null || attribute.tier() instanceof TransporterTier) continue;
                                CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, holder);
                            }
                            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.DIVERSION_TRANSPORTER);
                            break block7;
                        }
                        if (tabKey != CreativeModeTabs.TOOLS_AND_UTILITIES) break block11;
                        CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, new Holder[]{MekanismItems.CONFIGURATOR, MekanismItems.NETWORK_READER, MekanismItems.DOSIMETER, MekanismItems.GEIGER_COUNTER, MekanismItems.DICTIONARY, MekanismItems.CONFIGURATION_CARD, MekanismItems.GAUGE_DROPPER, MekanismItems.CRAFTING_FORMULA, MekanismItems.PORTABLE_QIO_DASHBOARD, MekanismItems.ATOMIC_DISASSEMBLER, MekanismItems.MEKA_TOOL, MekanismItems.SCUBA_MASK, MekanismItems.SCUBA_TANK, MekanismItems.FREE_RUNNERS, MekanismItems.ARMORED_FREE_RUNNERS, MekanismItems.JETPACK, MekanismItems.ARMORED_JETPACK, MekanismItems.HDPE_REINFORCED_ELYTRA, MekanismItems.HAZMAT_MASK, MekanismItems.HAZMAT_GOWN, MekanismItems.HAZMAT_PANTS, MekanismItems.HAZMAT_BOOTS, MekanismBlocks.CARDBOARD_BOX.getItemHolder(), MekanismItems.BASIC_TIER_INSTALLER, MekanismItems.ADVANCED_TIER_INSTALLER, MekanismItems.ELITE_TIER_INSTALLER, MekanismItems.ULTIMATE_TIER_INSTALLER, MekanismItems.SPEED_UPGRADE, MekanismItems.ENERGY_UPGRADE, MekanismItems.FILTER_UPGRADE, MekanismItems.MUFFLING_UPGRADE, MekanismItems.CHEMICAL_UPGRADE, MekanismItems.ANCHOR_UPGRADE, MekanismItems.STONE_GENERATOR_UPGRADE});
                        CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, MekanismBlocks.BASIC_FLUID_TANK, MekanismBlocks.ADVANCED_FLUID_TANK, MekanismBlocks.ELITE_FLUID_TANK, MekanismBlocks.ULTIMATE_FLUID_TANK, MekanismBlocks.CREATIVE_FLUID_TANK);
                        CreativeTabDeferredRegister.addToDisplay(MekanismFluids.FLUIDS, (CreativeModeTab.Output)event);
                        MekanismCreativeTabs.addFilledTanks(event.getParameters(), (CreativeModeTab.Output)event, false);
                        break block7;
                    }
                    if (tabKey != CreativeModeTabs.COMBAT) break block12;
                    CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, new Holder[]{MekanismItems.ATOMIC_DISASSEMBLER, MekanismItems.FLAMETHROWER, MekanismItems.ELECTRIC_BOW, MekanismItems.MEKA_TOOL, MekanismItems.MEKASUIT_HELMET, MekanismItems.MEKASUIT_BODYARMOR, MekanismItems.MEKASUIT_PANTS, MekanismItems.MEKASUIT_BOOTS, MekanismItems.ARMORED_FREE_RUNNERS, MekanismItems.ARMORED_JETPACK});
                    break block7;
                }
                if (tabKey != CreativeModeTabs.FOOD_AND_DRINKS) break block13;
                event.accept(FluidUtils.getFilledVariant(MekanismItems.CANTEEN, MekanismFluids.NUTRITIONAL_PASTE), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                break block7;
            }
            if (tabKey != CreativeModeTabs.INGREDIENTS) break block7;
            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, new Holder[]{MekanismItems.MODULE_BASE, MekanismItems.INFUSED_ALLOY, MekanismItems.REINFORCED_ALLOY, MekanismItems.ATOMIC_ALLOY, MekanismItems.BASIC_CONTROL_CIRCUIT, MekanismItems.ADVANCED_CONTROL_CIRCUIT, MekanismItems.ELITE_CONTROL_CIRCUIT, MekanismItems.ULTIMATE_CONTROL_CIRCUIT, MekanismItems.ENRICHED_CARBON, MekanismItems.ENRICHED_REDSTONE, MekanismItems.ENRICHED_DIAMOND, MekanismItems.ENRICHED_OBSIDIAN, MekanismItems.ENRICHED_GOLD, MekanismItems.ENRICHED_TIN, MekanismItems.BIO_FUEL, MekanismBlocks.BIO_FUEL_BLOCK.getItemHolder(), MekanismItems.SUBSTRATE, MekanismItems.HDPE_PELLET, MekanismItems.HDPE_ROD, MekanismItems.HDPE_SHEET, MekanismItems.ANTIMATTER_PELLET, MekanismItems.PLUTONIUM_PELLET, MekanismItems.POLONIUM_PELLET, MekanismItems.REPROCESSED_FISSILE_FRAGMENT, MekanismItems.ELECTROLYTIC_CORE, MekanismItems.TELEPORTATION_CORE, MekanismItems.ENRICHED_IRON, MekanismItems.SAWDUST, MekanismItems.SALT, MekanismItems.DYE_BASE, MekanismItems.FLUORITE_GEM, MekanismItems.FLUORITE_DUST, MekanismItems.YELLOW_CAKE_URANIUM, MekanismItems.DIRTY_NETHERITE_SCRAP, MekanismItems.NETHERITE_DUST, MekanismItems.CHARCOAL_DUST, MekanismItems.COAL_DUST, MekanismItems.SULFUR_DUST, MekanismItems.BRONZE_DUST, MekanismItems.LAPIS_LAZULI_DUST, MekanismItems.QUARTZ_DUST, MekanismItems.EMERALD_DUST, MekanismItems.DIAMOND_DUST, MekanismItems.STEEL_DUST, MekanismItems.OBSIDIAN_DUST, MekanismItems.REFINED_OBSIDIAN_DUST, MekanismItems.BRONZE_NUGGET, MekanismItems.STEEL_NUGGET, MekanismItems.REFINED_OBSIDIAN_NUGGET, MekanismItems.REFINED_GLOWSTONE_NUGGET, MekanismItems.BRONZE_INGOT, MekanismItems.STEEL_INGOT, MekanismItems.REFINED_OBSIDIAN_INGOT, MekanismItems.REFINED_GLOWSTONE_INGOT});
            for (Holder holder : MekanismItems.PROCESSED_RESOURCES.values()) {
                CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, holder);
            }
        }
    }
}

