/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.text.EnumColor;
import mekanism.common.ChemicalConstants;
import mekanism.common.Mekanism;
import mekanism.common.registration.impl.ChemicalDeferredRegister;
import mekanism.common.registration.impl.DeferredChemical;
import mekanism.common.registration.impl.SlurryRegistryObject;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.util.EnumUtils;

public class MekanismChemicals {
    public static final ChemicalDeferredRegister CHEMICALS = new ChemicalDeferredRegister("mekanism");
    public static final DeferredChemical<Chemical> BIO = CHEMICALS.register("bio", Mekanism.rl("infuse_type/bio"), 5916208);
    public static final DeferredChemical<Chemical> FUNGI = CHEMICALS.register("fungi", Mekanism.rl("infuse_type/fungi"), 7628138);
    public static final DeferredChemical<Chemical> TIN = CHEMICALS.registerInfuse("tin", 0xCCCCD9);
    public static final DeferredChemical<Chemical> GOLD = CHEMICALS.registerInfuse("gold", 15912295);
    public static final DeferredChemical<Chemical> REFINED_OBSIDIAN = CHEMICALS.registerInfuse("refined_obsidian", 8126701);
    public static final DeferredChemical<Chemical> DIAMOND = CHEMICALS.registerInfuse("diamond", 7138776);
    public static final DeferredChemical<Chemical> REDSTONE = CHEMICALS.registerInfuse("redstone", 11732229);
    public static final DeferredChemical<Chemical> CARBON = CHEMICALS.registerInfuse("carbon", 0x2C2C2C);
    public static final DeferredChemical<Chemical> HYDROGEN = CHEMICALS.register(ChemicalConstants.HYDROGEN);
    public static final DeferredChemical<Chemical> OXYGEN = CHEMICALS.register(ChemicalConstants.OXYGEN);
    public static final DeferredChemical<Chemical> STEAM = CHEMICALS.register("steam", () -> new Chemical(ChemicalBuilder.builder(Mekanism.rl("liquid/steam"))));
    public static final DeferredChemical<Chemical> WATER_VAPOR = CHEMICALS.register("water_vapor", () -> new Chemical(ChemicalBuilder.builder(Mekanism.rl("liquid/steam"))));
    public static final DeferredChemical<Chemical> CHLORINE = CHEMICALS.register(ChemicalConstants.CHLORINE);
    public static final DeferredChemical<Chemical> SULFUR_DIOXIDE = CHEMICALS.register(ChemicalConstants.SULFUR_DIOXIDE);
    public static final DeferredChemical<Chemical> SULFUR_TRIOXIDE = CHEMICALS.register(ChemicalConstants.SULFUR_TRIOXIDE);
    public static final DeferredChemical<Chemical> SULFURIC_ACID = CHEMICALS.register(ChemicalConstants.SULFURIC_ACID);
    public static final DeferredChemical<Chemical> HYDROGEN_CHLORIDE = CHEMICALS.register(ChemicalConstants.HYDROGEN_CHLORIDE);
    public static final DeferredChemical<Chemical> HYDROFLUORIC_ACID = CHEMICALS.register(ChemicalConstants.HYDROFLUORIC_ACID);
    public static final DeferredChemical<Chemical> URANIUM_OXIDE = CHEMICALS.register(ChemicalConstants.URANIUM_OXIDE);
    public static final DeferredChemical<Chemical> URANIUM_HEXAFLUORIDE = CHEMICALS.register(ChemicalConstants.URANIUM_HEXAFLUORIDE);
    public static final DeferredChemical<Chemical> ETHENE = CHEMICALS.register(ChemicalConstants.ETHENE);
    public static final DeferredChemical<Chemical> SODIUM = CHEMICALS.register(ChemicalConstants.SODIUM);
    public static final DeferredChemical<Chemical> SUPERHEATED_SODIUM = CHEMICALS.register(ChemicalConstants.SUPERHEATED_SODIUM);
    public static final DeferredChemical<Chemical> BRINE = CHEMICALS.register("brine", 16707484);
    public static final DeferredChemical<Chemical> LITHIUM = CHEMICALS.register(ChemicalConstants.LITHIUM);
    public static final DeferredChemical<Chemical> OSMIUM = CHEMICALS.register("osmium", 5422538);
    public static final DeferredChemical<Chemical> FISSILE_FUEL = CHEMICALS.register("fissile_fuel", 3027759);
    public static final DeferredChemical<Chemical> NUCLEAR_WASTE = CHEMICALS.register("nuclear_waste", 5194026);
    public static final DeferredChemical<Chemical> SPENT_NUCLEAR_WASTE = CHEMICALS.register("spent_nuclear_waste", 2498581);
    public static final DeferredChemical<Chemical> PLUTONIUM = CHEMICALS.register("plutonium", 2068892);
    public static final DeferredChemical<Chemical> POLONIUM = CHEMICALS.register("polonium", 1810043);
    public static final DeferredChemical<Chemical> ANTIMATTER = CHEMICALS.register("antimatter", 10773683);
    public static Map<EnumColor, DeferredChemical<Chemical>> PIGMENT_COLOR_LOOKUP = new EnumMap<EnumColor, DeferredChemical<Chemical>>(EnumColor.class);
    public static final Map<PrimaryResource, SlurryRegistryObject<Chemical, Chemical>> PROCESSED_RESOURCES = new LinkedHashMap<PrimaryResource, SlurryRegistryObject<Chemical, Chemical>>();

    private MekanismChemicals() {
    }

    private static DeferredChemical<Chemical> registerPigment(EnumColor color) {
        int[] rgb = color.getRgbCode();
        int tint = rgb[0] << 16;
        tint |= rgb[1] << 8;
        return CHEMICALS.registerPigment(color.getRegistryPrefix(), tint |= rgb[2]);
    }

    static {
        for (EnumColor enumColor : EnumUtils.COLORS) {
            PIGMENT_COLOR_LOOKUP.put(enumColor, MekanismChemicals.registerPigment(enumColor));
        }
        for (Enum enum_ : EnumUtils.PRIMARY_RESOURCES) {
            PROCESSED_RESOURCES.put((PrimaryResource)enum_, CHEMICALS.registerSlurry((PrimaryResource)enum_));
        }
    }
}

