/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.math.Range3D;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicBufferedNetwork<ACCEPTOR, NETWORK extends DynamicBufferedNetwork<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>, BUFFER, TRANSMITTER extends BufferedTransmitter<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>>
extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER> {
    protected final LongSet chunks = new LongOpenHashSet();
    @Nullable
    protected Range3D packetRange;
    protected long capacity;
    protected boolean needsUpdate;
    private boolean forceScaleUpdate;
    private long lastSaveShareWriteTime;
    private long lastMarkDirtyTime;
    public float currentScale;

    protected DynamicBufferedNetwork(UUID networkID) {
        super(networkID);
    }

    protected abstract float computeContentScale();

    @Override
    public void onUpdate() {
        super.onUpdate();
        float scale = this.computeContentScale();
        if (scale != this.currentScale) {
            this.currentScale = scale;
            this.needsUpdate = true;
        }
    }

    @Override
    public void addNewTransmitters(Collection<TRANSMITTER> newTransmitters, CompatibleTransmitterValidator<ACCEPTOR, NETWORK, TRANSMITTER> transmitterValidator) {
        super.addNewTransmitters(newTransmitters, transmitterValidator);
        if (!this.forceScaleUpdate) {
            this.forceScaleUpdate = this.isEmpty();
        }
    }

    @Override
    protected void addTransmitterFromCommit(TRANSMITTER transmitter) {
        super.addTransmitterFromCommit(transmitter);
        this.chunks.add(ChunkPos.asLong((BlockPos)((Transmitter)transmitter).getBlockPos()));
        this.updateCapacity(transmitter);
        this.absorbBuffer(transmitter);
    }

    @Override
    protected void validTransmittersAdded() {
        super.validTransmittersAdded();
        this.clampBuffer();
        if (this.forceScaleUpdate) {
            this.forceScaleUpdate = false;
            this.forceScaleUpdate();
        }
        this.needsUpdate = true;
        this.packetRange = null;
    }

    @Override
    public List<TRANSMITTER> adoptTransmittersAndAcceptorsFrom(NETWORK net) {
        List transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        this.chunks.addAll((LongCollection)((DynamicBufferedNetwork)net).chunks);
        this.updateCapacity();
        return transmittersToUpdate;
    }

    @Override
    protected void removeInvalid(@Nullable TRANSMITTER triggerTransmitter) {
        super.removeInvalid(triggerTransmitter);
        this.clampBuffer();
        this.updateSaveShares(triggerTransmitter);
    }

    @Override
    public void deregister() {
        super.deregister();
        this.chunks.clear();
        this.packetRange = null;
    }

    protected abstract void forceScaleUpdate();

    @NotNull
    public abstract BUFFER getBuffer();

    public abstract void absorbBuffer(TRANSMITTER var1);

    public abstract void clampBuffer();

    public boolean isCompatibleWith(NETWORK other) {
        return true;
    }

    protected synchronized void updateCapacity(TRANSMITTER transmitter) {
        long transmitterCapacity = ((BufferedTransmitter)transmitter).getCapacity();
        this.capacity = transmitterCapacity > Long.MAX_VALUE - this.capacity ? Long.MAX_VALUE : (this.capacity += transmitterCapacity);
    }

    public synchronized void updateCapacity() {
        long sum = 0L;
        for (BufferedTransmitter transmitter : this.getTransmitters()) {
            long transmitterCapacity = transmitter.getCapacity();
            if (transmitterCapacity > Long.MAX_VALUE - this.capacity) {
                sum = Long.MAX_VALUE;
                break;
            }
            sum += transmitterCapacity;
        }
        if (this.capacity != sum) {
            this.capacity = sum;
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public Object getNetworkReaderCapacity() {
        return this.getCapacity();
    }

    protected void updateSaveShares(@Nullable TRANSMITTER triggerTransmitter) {
    }

    public final void validateSaveShares(@NotNull TRANSMITTER triggerTransmitter) {
        if (this.world == null) {
            this.world = ((Transmitter)triggerTransmitter).getLevel();
        }
        if (this.world != null && this.world.getGameTime() != this.lastSaveShareWriteTime) {
            this.lastSaveShareWriteTime = this.world.getGameTime();
            this.updateSaveShares(triggerTransmitter);
        }
    }

    public void markDirty() {
        if (this.world != null && !this.world.isClientSide && this.world.getGameTime() != this.lastMarkDirtyTime) {
            this.lastMarkDirtyTime = this.world.getGameTime();
            LongIterator iterator = this.chunks.iterator();
            while (iterator.hasNext()) {
                long chunk = iterator.nextLong();
                WorldUtils.markChunkDirty(this.world, ChunkPos.getX((long)chunk), ChunkPos.getZ((long)chunk));
            }
        }
    }

    public Range3D getPacketRange() {
        if (this.packetRange == null) {
            this.packetRange = this.genPacketRange();
        }
        return this.packetRange;
    }

    private Range3D genPacketRange() {
        if (this.isEmpty()) {
            this.deregister();
            return null;
        }
        boolean initialized = false;
        int minX = 0;
        int minZ = 0;
        int maxX = 0;
        int maxZ = 0;
        for (BufferedTransmitter transmitter : this.getTransmitters()) {
            BlockPos pos = transmitter.getBlockPos();
            if (initialized) {
                if (pos.getX() < minX) {
                    minX = pos.getX();
                } else if (pos.getX() > maxX) {
                    maxX = pos.getX();
                }
                if (pos.getZ() < minZ) {
                    minZ = pos.getZ();
                    continue;
                }
                if (pos.getZ() <= maxZ) continue;
                maxZ = pos.getZ();
                continue;
            }
            minX = pos.getX();
            minZ = pos.getZ();
            maxX = minX;
            maxZ = minZ;
            initialized = true;
        }
        return new Range3D(minX, minZ, maxX, maxZ, (ResourceKey<Level>)this.world.dimension());
    }

    public static class TransferEvent<NETWORK extends DynamicBufferedNetwork<?, NETWORK, ?, ?>>
    extends Event {
        public final NETWORK network;

        public TransferEvent(NETWORK network) {
            this.network = network;
        }
    }
}

