/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.math.voxel.IShape;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IInternalMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.tile.prefab.TileEntityStructuralMultiblock;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockData
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IMekanismChemicalHandler {
    public Set<BlockPos> locations = new ObjectOpenHashSet();
    public Set<BlockPos> internalLocations = new ObjectOpenHashSet();
    public Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    @ContainerSync(getter="getVolume", setter="setVolume")
    private int volume;
    public UUID inventoryID;
    public boolean hasMaster;
    @Nullable
    public BlockPos renderLocation;
    @ContainerSync
    private VoxelCuboid bounds = new VoxelCuboid(0, 0, 0);
    @ContainerSync
    private boolean formed;
    public boolean recheckStructure;
    private int currentRedstoneLevel = 0;
    private final BooleanSupplier remoteSupplier;
    private final Supplier<Level> worldSupplier;
    protected final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    protected final List<IExtendedFluidTank> fluidTanks = new ArrayList<IExtendedFluidTank>();
    protected final List<IChemicalTank> chemicalTanks = new ArrayList<IChemicalTank>();
    protected final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    protected final List<IHeatCapacitor> heatCapacitors = new ArrayList<IHeatCapacitor>();
    private final BiPredicate<Object, @NotNull AutomationType> formedBiPred = (t, automationType) -> this.isFormed();
    private final BiPredicate<Object, @NotNull AutomationType> notExternalFormedBiPred = (t, automationType) -> automationType != AutomationType.EXTERNAL && this.isFormed();
    private boolean dirty;

    public MultiblockData(BlockEntity tile) {
        this.remoteSupplier = () -> tile.getLevel().isClientSide();
        this.worldSupplier = () -> ((BlockEntity)tile).getLevel();
    }

    public <T> BiPredicate<T, @NotNull AutomationType> formedBiPred() {
        return this.formedBiPred;
    }

    public <T> BiPredicate<T, @NotNull AutomationType> notExternalFormedBiPred() {
        return this.notExternalFormedBiPred;
    }

    protected IContentsListener createSaveAndComparator() {
        return this.createSaveAndComparator(this);
    }

    protected IContentsListener createSaveAndComparator(IContentsListener contentsListener) {
        return () -> {
            contentsListener.onContentsChanged();
            if (!this.isRemote()) {
                this.markDirtyComparator(this.getLevel());
            }
        };
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean allowsStructuralGuiAccess(TileEntityStructuralMultiblock multiblock) {
        return true;
    }

    public boolean tick(Level world) {
        boolean needsPacket = false;
        for (IValveHandler.ValveData data : this.valves) {
            data.activeTicks = Math.max(0, data.activeTicks - 1);
            if (data.activeTicks > 0 != data.prevActive) {
                needsPacket = true;
            }
            data.prevActive = data.activeTicks > 0;
        }
        return needsPacket;
    }

    protected double calculateAverageAmbientTemperature(Level world) {
        BlockPos min = this.getMinPos();
        BlockPos max = this.getMaxPos();
        return HeatAPI.getAmbientTemp(MultiblockData.getBiomeTemp(world, min, new BlockPos(max.getX(), min.getY(), min.getZ()), new BlockPos(min.getX(), min.getY(), max.getZ()), new BlockPos(max.getX(), min.getY(), max.getZ()), new BlockPos(min.getX(), max.getY(), min.getZ()), new BlockPos(max.getX(), max.getY(), min.getZ()), new BlockPos(min.getX(), max.getY(), max.getZ()), max));
    }

    private static double getBiomeTemp(Level world, BlockPos ... positions) {
        if (positions.length == 0) {
            throw new IllegalArgumentException("No positions given.");
        }
        double sum = 0.0;
        for (BlockPos pos : positions) {
            sum += (double)((Biome)world.getBiome(pos).value()).getTemperature(pos);
        }
        return sum / (double)positions.length;
    }

    public boolean setShape(IShape shape) {
        if (shape instanceof VoxelCuboid) {
            VoxelCuboid cuboid;
            this.bounds = cuboid = (VoxelCuboid)shape;
            this.renderLocation = cuboid.getMinPos().relative(Direction.UP);
            this.setVolume(this.bounds.length() * this.bounds.width() * this.bounds.height());
            return true;
        }
        return false;
    }

    public void onCreated(Level world) {
        BlockEntity tile;
        for (BlockPos blockPos : this.internalLocations) {
            tile = WorldUtils.getTileEntity((BlockGetter)world, blockPos);
            if (!(tile instanceof IInternalMultiblock)) continue;
            IInternalMultiblock internalMultiblock = (IInternalMultiblock)tile;
            internalMultiblock.setMultiblock(this);
        }
        for (BlockPos blockPos : this.locations) {
            tile = WorldUtils.getTileEntity((BlockGetter)world, blockPos);
            if (!(tile instanceof IStructuralMultiblock)) continue;
            IStructuralMultiblock structuralMultiblock = (IStructuralMultiblock)tile;
            structuralMultiblock.multiblockFormed(this);
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.FLUID)) {
            for (IExtendedFluidTank iExtendedFluidTank : this.getFluidTanks(null)) {
                iExtendedFluidTank.setStackSize(Math.min(iExtendedFluidTank.getFluidAmount(), iExtendedFluidTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.CHEMICAL)) {
            for (IChemicalTank iChemicalTank : this.getChemicalTanks(null)) {
                iChemicalTank.setStackSize(Math.min(iChemicalTank.getStored(), iChemicalTank.getCapacity()), Action.EXECUTE);
            }
        }
        if (this.shouldCap(MultiblockCache.CacheSubstance.ENERGY)) {
            for (IEnergyContainer iEnergyContainer : this.getEnergyContainers(null)) {
                iEnergyContainer.setEnergy(Math.min(iEnergyContainer.getEnergy(), iEnergyContainer.getMaxEnergy()));
            }
        }
        this.updateEjectors(world);
        this.forceUpdateComparatorLevel();
    }

    protected void updateEjectors(Level world) {
    }

    protected boolean isRemote() {
        return this.remoteSupplier.getAsBoolean();
    }

    public Level getLevel() {
        return this.worldSupplier.get();
    }

    protected boolean shouldCap(MultiblockCache.CacheSubstance<?, ?> type) {
        return true;
    }

    public void remove(Level world, Structure oldStructure) {
        BlockEntity tile;
        for (BlockPos pos : this.internalLocations) {
            tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            if (!(tile instanceof IInternalMultiblock)) continue;
            IInternalMultiblock internalMultiblock = (IInternalMultiblock)tile;
            internalMultiblock.setMultiblock(null);
        }
        for (BlockPos pos : this.locations) {
            tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            if (!(tile instanceof IStructuralMultiblock)) continue;
            IStructuralMultiblock structuralMultiblock = (IStructuralMultiblock)tile;
            structuralMultiblock.multiblockUnformed(oldStructure);
        }
        this.inventoryID = null;
        this.formed = false;
        this.recheckStructure = false;
    }

    public void meltdownHappened(Level world) {
    }

    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        NBTUtils.setIntIfPresent(tag, "volume", this::setVolume);
        NBTUtils.setBlockPosIfPresent(tag, "render_location", value -> {
            this.renderLocation = value;
        });
        Optional minPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"min");
        Optional maxPos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"max");
        if (minPos.isPresent() && maxPos.isPresent()) {
            this.bounds = new VoxelCuboid((BlockPos)minPos.get(), (BlockPos)maxPos.get());
        }
        NBTUtils.setUUIDIfPresentElse(tag, "inventory_id", value -> {
            this.inventoryID = value;
        }, () -> {
            this.inventoryID = null;
        });
    }

    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("volume", this.getVolume());
        if (this.renderLocation != null) {
            tag.put("render_location", NbtUtils.writeBlockPos((BlockPos)this.renderLocation));
        }
        tag.put("min", NbtUtils.writeBlockPos((BlockPos)this.bounds.getMinPos()));
        tag.put("max", NbtUtils.writeBlockPos((BlockPos)this.bounds.getMaxPos()));
        if (this.inventoryID != null) {
            tag.putUUID("inventory_id", this.inventoryID);
        }
    }

    @ComputerMethod(nameOverride="getLength")
    public int length() {
        return this.bounds.length();
    }

    @ComputerMethod(nameOverride="getWidth")
    public int width() {
        return this.bounds.width();
    }

    @ComputerMethod(nameOverride="getHeight")
    public int height() {
        return this.bounds.height();
    }

    @ComputerMethod
    public BlockPos getMinPos() {
        return this.bounds.getMinPos();
    }

    @ComputerMethod
    public BlockPos getMaxPos() {
        return this.bounds.getMaxPos();
    }

    public VoxelCuboid getBounds() {
        return this.bounds;
    }

    public <T extends MultiblockData> boolean isPositionInsideBounds(@NotNull Structure structure, @NotNull BlockPos pos) {
        if (this.isFormed()) {
            IStructureValidator<?> validator;
            MultiblockManager<?> manager;
            VoxelCuboid.CuboidRelative relativeLocation = this.getBounds().getRelativeLocation(pos);
            if (relativeLocation == VoxelCuboid.CuboidRelative.INSIDE) {
                return true;
            }
            if (relativeLocation.isWall() && (manager = structure.getManager()) != null && (validator = manager.createValidator()) instanceof CuboidStructureValidator) {
                CuboidStructureValidator cuboidValidator = (CuboidStructureValidator)validator;
                validator.init(this.getLevel(), manager, structure);
                cuboidValidator.loadCuboid(this.getBounds());
                return cuboidValidator.getStructureRequirement(pos) == FormationProtocol.StructureRequirement.INNER;
            }
        }
        return false;
    }

    public boolean isPositionOutsideBounds(@NotNull BlockPos pos) {
        return this.isFormed() && this.getBounds().getRelativeLocation(pos) == VoxelCuboid.CuboidRelative.OUTSIDE;
    }

    @Nullable
    public Direction getOutsideSide(@NotNull BlockPos pos) {
        if (this.isFormed()) {
            VoxelCuboid bounds = this.getBounds();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : EnumUtils.DIRECTIONS) {
                mutable.setWithOffset((Vec3i)pos, direction);
                if (bounds.getRelativeLocation((BlockPos)mutable) != VoxelCuboid.CuboidRelative.OUTSIDE) continue;
                return direction;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.isFormed() || this.isRemote() ? this.inventorySlots : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.isFormed() || this.isRemote() ? this.fluidTanks : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.isFormed() || this.isRemote() ? this.chemicalTanks : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.isFormed() || this.isRemote() ? this.energyContainers : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.isFormed() || this.isRemote() ? this.heatCapacitors : Collections.emptyList();
    }

    public boolean isKnownLocation(BlockPos pos) {
        return this.locations.contains(pos) || this.internalLocations.contains(pos);
    }

    public Collection<IValveHandler.ValveData> getValveData() {
        return this.valves;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.locations.hashCode();
        code = 31 * code + this.bounds.hashCode();
        code = 31 * code + this.getVolume();
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MultiblockData data = (MultiblockData)obj;
        if (!data.locations.equals(this.locations)) {
            return false;
        }
        if (!data.bounds.equals(this.bounds)) {
            return false;
        }
        return data.getVolume() == this.getVolume();
    }

    public boolean isFormed() {
        return this.formed;
    }

    public void setFormedForce(boolean formed) {
        this.formed = formed;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void markDirtyComparator(Level world) {
        if (!this.isFormed()) {
            return;
        }
        int newRedstoneLevel = this.getMultiblockRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.currentRedstoneLevel = newRedstoneLevel;
            this.notifyAllUpdateComparator(world);
        }
    }

    public void notifyAllUpdateComparator(Level world) {
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityMultiblock tile = WorldUtils.getTileEntity(TileEntityMultiblock.class, (BlockGetter)world, valve.location);
            if (tile == null) continue;
            tile.markDirtyComparator();
        }
    }

    public void forceUpdateComparatorLevel() {
        this.currentRedstoneLevel = this.getMultiblockRedstoneLevel();
    }

    protected int getMultiblockRedstoneLevel() {
        return 0;
    }

    public int getCurrentRedstoneLevel() {
        return this.currentRedstoneLevel;
    }

    protected <CACHE> List<CACHE> getActiveOutputs(List<? extends OutputTarget<CACHE, Void>> outputs) {
        return this.getActiveOutputs(outputs, null);
    }

    protected <CACHE, DATA> List<CACHE> getActiveOutputs(List<? extends OutputTarget<CACHE, DATA>> outputs, DATA data) {
        ArrayList<CACHE> targets = new ArrayList<CACHE>(outputs.size());
        for (OutputTarget<CACHE, DATA> target : outputs) {
            if (!target.canOutput(data)) continue;
            targets.add(target.cache());
        }
        return targets;
    }

    protected static interface OutputTarget<CACHE, DATA> {
        public CACHE cache();

        public boolean canOutput(DATA var1);
    }

    public static final class AdvancedCapabilityOutputTarget<TYPE, DATA>
    extends Record
    implements OutputTarget<BlockCapabilityCache<TYPE, Direction>, DATA> {
        private final BlockCapabilityCache<TYPE, @Nullable Direction> cache;
        private final Predicate<DATA> isActive;

        public AdvancedCapabilityOutputTarget(BlockCapabilityCache<TYPE, @Nullable Direction> cache, Predicate<DATA> isActive) {
            this.cache = cache;
            this.isActive = isActive;
        }

        @Override
        public boolean canOutput(DATA data) {
            return this.isActive.test(data);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AdvancedCapabilityOutputTarget.class, "cache;isActive", "cache", "isActive"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AdvancedCapabilityOutputTarget.class, "cache;isActive", "cache", "isActive"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AdvancedCapabilityOutputTarget.class, "cache;isActive", "cache", "isActive"}, this, o);
        }

        @Override
        public BlockCapabilityCache<TYPE, @Nullable Direction> cache() {
            return this.cache;
        }

        public Predicate<DATA> isActive() {
            return this.isActive;
        }
    }

    public static final class CapabilityOutputTarget<TYPE>
    extends Record
    implements OutputTarget<BlockCapabilityCache<TYPE, Direction>, Void> {
        private final BlockCapabilityCache<TYPE, @Nullable Direction> cache;
        private final BooleanSupplier isActive;

        public CapabilityOutputTarget(BlockCapabilityCache<TYPE, @Nullable Direction> cache, BooleanSupplier isActive) {
            this.cache = cache;
            this.isActive = isActive;
        }

        @Override
        public boolean canOutput(Void unused) {
            return this.isActive.getAsBoolean();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CapabilityOutputTarget.class, "cache;isActive", "cache", "isActive"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CapabilityOutputTarget.class, "cache;isActive", "cache", "isActive"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CapabilityOutputTarget.class, "cache;isActive", "cache", "isActive"}, this, o);
        }

        @Override
        public BlockCapabilityCache<TYPE, @Nullable Direction> cache() {
            return this.cache;
        }

        public BooleanSupplier isActive() {
            return this.isActive;
        }
    }

    public static final class EnergyOutputTarget
    extends Record
    implements OutputTarget<BlockEnergyCapabilityCache, Void> {
        private final BlockEnergyCapabilityCache cache;
        private final BooleanSupplier isActive;

        public EnergyOutputTarget(BlockEnergyCapabilityCache cache, BooleanSupplier isActive) {
            this.cache = cache;
            this.isActive = isActive;
        }

        @Override
        public boolean canOutput(Void unused) {
            return this.isActive.getAsBoolean();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnergyOutputTarget.class, "cache;isActive", "cache", "isActive"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnergyOutputTarget.class, "cache;isActive", "cache", "isActive"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnergyOutputTarget.class, "cache;isActive", "cache", "isActive"}, this, o);
        }

        @Override
        public BlockEnergyCapabilityCache cache() {
            return this.cache;
        }

        public BooleanSupplier isActive() {
            return this.isActive;
        }
    }
}

