/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import mekanism.api.security.SecurityMode;
import mekanism.common.Mekanism;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;

public class FrequencyManagerWrapper<FREQ extends Frequency> {
    private final Type type;
    private final FrequencyType<FREQ> frequencyType;
    private FrequencyManager<FREQ> publicManager;
    private Map<UUID, FrequencyManager<FREQ>> privateManagers;
    private Map<UUID, FrequencyManager<FREQ>> trustedManagers;

    private FrequencyManagerWrapper(Type type, FrequencyType<FREQ> frequencyType) {
        this.type = type;
        this.frequencyType = frequencyType;
        if (type.supportsPublic()) {
            this.publicManager = new FrequencyManager<FREQ>(frequencyType);
        }
        if (type.supportsPrivate()) {
            this.privateManagers = new Object2ObjectOpenHashMap();
        }
        if (type.supportsTrusted()) {
            this.trustedManagers = new Object2ObjectOpenHashMap();
        }
    }

    public static <FREQ extends Frequency> FrequencyManagerWrapper<FREQ> create(FrequencyType<FREQ> frequencyType, Type type) {
        return new FrequencyManagerWrapper<FREQ>(type, frequencyType);
    }

    public FrequencyManager<FREQ> getPublicManager() {
        if (!this.type.supportsPublic()) {
            Mekanism.logger.error("Attempted to access public frequency manager of type {}. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        return this.publicManager;
    }

    public FrequencyManager<FREQ> getPrivateManager(UUID ownerUUID) {
        if (!this.type.supportsPrivate()) {
            Mekanism.logger.error("Attempted to access private frequency manager of type {}. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        if (ownerUUID == null) {
            Mekanism.logger.error("Attempted to access private frequency manager of type {} with no owner. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        FrequencyManager<FREQ> manager = this.privateManagers.get(ownerUUID);
        if (manager == null) {
            manager = new FrequencyManager<FREQ>(this.frequencyType, ownerUUID, SecurityMode.PRIVATE);
            manager.createOrLoad();
            this.privateManagers.put(ownerUUID, manager);
        }
        return manager;
    }

    public FrequencyManager<FREQ> getTrustedManager(UUID ownerUUID) {
        if (!this.type.supportsTrusted()) {
            Mekanism.logger.error("Attempted to access trusted frequency manager of type {}. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        if (ownerUUID == null) {
            Mekanism.logger.error("Attempted to access trusted frequency manager of type {} with no owner. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        FrequencyManager<FREQ> manager = this.trustedManagers.get(ownerUUID);
        if (manager == null) {
            manager = new FrequencyManager<FREQ>(this.frequencyType, ownerUUID, SecurityMode.TRUSTED);
            manager.createOrLoad();
            this.trustedManagers.put(ownerUUID, manager);
        }
        return manager;
    }

    public Collection<FrequencyManager<FREQ>> getTrustedManagers() {
        return this.trustedManagers.values();
    }

    public void clear() {
        if (this.privateManagers != null) {
            this.privateManagers.clear();
        }
        if (this.trustedManagers != null) {
            this.trustedManagers.clear();
        }
    }

    public static enum Type {
        PUBLIC_ONLY,
        PRIVATE_ONLY,
        PUBLIC_PRIVATE_TRUSTED;


        boolean supportsPublic() {
            return this == PUBLIC_ONLY || this == PUBLIC_PRIVATE_TRUSTED;
        }

        boolean supportsTrusted() {
            return this == PUBLIC_PRIVATE_TRUSTED;
        }

        boolean supportsPrivate() {
            return this == PRIVATE_ONLY || this == PUBLIC_PRIVATE_TRUSTED;
        }
    }
}

