/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import mekanism.common.lib.distribution.SplitInfo;

public class LongSplitInfo
extends SplitInfo {
    private long amountToSplit;
    private long amountPerTarget;
    private long sentSoFar;
    private long remainder;

    public LongSplitInfo(long amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit;
        this.amountPerTarget = this.toSplitAmong == 0 ? 0L : amountToSplit / (long)this.toSplitAmong;
        this.remainder = this.toSplitAmong == 0 ? 0L : amountToSplit % (long)this.toSplitAmong;
    }

    @Override
    public void send(long amountNeeded) {
        this.amountToSplit -= amountNeeded;
        this.sentSoFar += amountNeeded;
        if (!this.decrementTargets) {
            long difference = amountNeeded - this.amountPerTarget;
            if (difference > 0L) {
                this.remainder -= difference;
            }
            return;
        }
        --this.toSplitAmong;
        if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
            long amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit / (long)this.toSplitAmong;
            this.remainder = this.amountToSplit % (long)this.toSplitAmong;
            if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public long getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public long getRemainderAmount() {
        if (this.toSplitAmong != 0 && this.remainder > 0L) {
            return this.amountPerTarget + 1L;
        }
        return this.amountPerTarget;
    }

    @Override
    public long getUnsent() {
        return this.amountToSplit;
    }

    @Override
    public long getTotalSent() {
        return this.sentSoFar;
    }
}

